/*
 * Decompiled with CFR 0.152.
 */
package com.lin.creator;

import com.lin.creator.BaseFakerCreator;
import com.lin.entity.common.CommonFieldInfo;
import com.lin.entity.common.CommonTableInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class OracleFakerCreator
extends BaseFakerCreator<CommonTableInfo, CommonFieldInfo> {
    public static BaseFakerCreator url(String url) {
        return FakerCreatorHolder.INSTANCE.setUrl(url);
    }

    public static BaseFakerCreator dbName(String dbName) {
        return FakerCreatorHolder.INSTANCE.setDbName(dbName);
    }

    @Override
    protected String getQueryTablesInfoSql() {
        return "select table_name as tableName, comments as tableComment from user_tab_comments";
    }

    @Override
    protected String getQueryFieldsInfoSql(String tableName) {
        return String.format("select a.column_name as fieldName, a.data_type as dataType, b.comments as comments from user_tab_columns a left join user_col_comments b on b.column_name = a.column_name where a.table_name = '%s' and b.table_name = '%s' order by a.column_id", tableName.toUpperCase(), tableName.toUpperCase());
    }

    @Override
    protected String getDefaultUsername() {
        return "test1";
    }

    @Override
    protected String getDefaultPassword() {
        return "123456";
    }

    @Override
    protected String getDefaultDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    protected String getDefaultUrlPrefix() {
        return "jdbc:oracle:thin:@localhost:1521/";
    }

    @Override
    protected void setDbStringTypeSet(Collection<String> dbStringTypeSet) {
        dbStringTypeSet.addAll(Arrays.asList("CHAR", "NCHAR", "VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "TINYBLOB", "TINYTEXT", "BLOB", "CLOB", "NCLOB", "BFILE", "TEXT", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "VARBINARY", "BINARY", "UDT", "UNIQUEIDENTIFIER", "XML", "SQLVARIANT", "GEOMETRY", "IMAGE", "GEOGRAPHY", "ROWID", "NROWID", "RAW", "LONG", "LONG\u2002RAW"));
    }

    @Override
    protected void setDatabaseInferMap(Map<String, String> databaseInferMap) {
        databaseInferMap.put("BIGINT", "INT");
        databaseInferMap.put("TINYINT", "INT");
        databaseInferMap.put("SMALLINT", "INT");
        databaseInferMap.put("MEDIUMINT", "INT");
        databaseInferMap.put("INT", "INT");
        databaseInferMap.put("INTEGER", "INT");
        databaseInferMap.put("SMALLMONEY", "INT");
        databaseInferMap.put("FLOAT", "FLOAT");
        databaseInferMap.put("DOUBLE", "FLOAT");
        databaseInferMap.put("DECIMAL", "FLOAT");
        databaseInferMap.put("BIT", "FLOAT");
        databaseInferMap.put("SSNOVERSION", "FLOAT");
        databaseInferMap.put("MONEY", "FLOAT");
        databaseInferMap.put("NTEXT", "FLOAT");
        databaseInferMap.put("NUMERIC", "FLOAT");
        databaseInferMap.put("NUMBER", "FLOAT");
        databaseInferMap.put("REAL", "FLOAT");
        databaseInferMap.put("BINARY_FLOAT", "FLOAT");
        databaseInferMap.put("BINARY_DOUBLE", "FLOAT");
        databaseInferMap.put("DATE", "TIME");
        databaseInferMap.put("TIME", "TIME");
        databaseInferMap.put("YEAR", "TIME");
        databaseInferMap.put("DAY", "TIME");
        databaseInferMap.put("HOUR", "TIME");
        databaseInferMap.put("MINUTE", "TIME");
        databaseInferMap.put("SECOND", "TIME");
        databaseInferMap.put("TIMEZONE_HOUR", "TIME");
        databaseInferMap.put("TIMEZONE_MINUTE", "TIME");
        databaseInferMap.put("TIMEZONE_REGION", "TIME");
        databaseInferMap.put("TIMEZONE_ABBR\u2002", "TIME");
        databaseInferMap.put("DATETIME", "TIME");
        databaseInferMap.put("DATETIME2", "TIME");
        databaseInferMap.put("DATETIMEOFFSET", "TIME");
        databaseInferMap.put("TIMESTAMP", "TIME");
        databaseInferMap.put("INTERVAL\u2002YEAR", "TIME");
        databaseInferMap.put("INTERVAL\u2002DAY", "TIME");
        databaseInferMap.put("SMALLDATETIME", "TIME");
        databaseInferMap.put("CHAR", "TEXT");
        databaseInferMap.put("NCHAR", "TEXT");
        databaseInferMap.put("VARCHAR", "TEXT");
        databaseInferMap.put("VARCHAR2", "TEXT");
        databaseInferMap.put("NVARCHAR", "TEXT");
        databaseInferMap.put("NVARCHAR2", "TEXT");
        databaseInferMap.put("TINYBLOB", "TEXT");
        databaseInferMap.put("TINYTEXT", "TEXT");
        databaseInferMap.put("BLOB", "TEXT");
        databaseInferMap.put("CLOB", "TEXT");
        databaseInferMap.put("NCLOB", "TEXT");
        databaseInferMap.put("BFILE", "TEXT");
        databaseInferMap.put("TEXT", "TEXT");
        databaseInferMap.put("MEDIUMBLOB", "TEXT");
        databaseInferMap.put("MEDIUMTEXT", "TEXT");
        databaseInferMap.put("LONGBLOB", "TEXT");
        databaseInferMap.put("LONGTEXT", "TEXT");
        databaseInferMap.put("VARBINARY", "TEXT");
        databaseInferMap.put("BINARY", "TEXT");
        databaseInferMap.put("UDT", "TEXT");
        databaseInferMap.put("UNIQUEIDENTIFIER", "TEXT");
        databaseInferMap.put("XML", "TEXT");
        databaseInferMap.put("SQLVARIANT", "TEXT");
        databaseInferMap.put("GEOMETRY", "TEXT");
        databaseInferMap.put("IMAGE", "TEXT");
        databaseInferMap.put("GEOGRAPHY", "TEXT");
        databaseInferMap.put("ROWID", "TEXT");
        databaseInferMap.put("NROWID", "TEXT");
        databaseInferMap.put("RAW", "TEXT");
        databaseInferMap.put("LONG", "TEXT");
        databaseInferMap.put("LONG\u2002RAW", "TEXT");
    }

    private static final class FakerCreatorHolder {
        private static final BaseFakerCreator INSTANCE = new OracleFakerCreator();

        private FakerCreatorHolder() {
        }
    }
}

