/*
 * Decompiled with CFR 0.152.
 */
package com.lin.creator;

import com.lin.creator.BaseFakerCreator;
import com.lin.creator.H2FakerCreator;
import com.lin.creator.MysqlFakerCreator;
import com.lin.creator.OracleFakerCreator;
import com.lin.creator.SqlServerFakerCreator;
import com.lin.creator.SqliteFakerCreator;
import com.lin.creator.enums.DatabaseType;

public class FakerCreator {
    private static DatabaseType databaseType = null;

    public static FakerCreator mysql() {
        return FakerCreator.setDatabaseType(DatabaseType.MYSQL);
    }

    public static FakerCreator sqlServer() {
        return FakerCreator.setDatabaseType(DatabaseType.SQL_SERVER);
    }

    public static FakerCreator oracle() {
        return FakerCreator.setDatabaseType(DatabaseType.ORACLE);
    }

    public static FakerCreator sqlite() {
        return FakerCreator.setDatabaseType(DatabaseType.SQLITE);
    }

    public static FakerCreator h2() {
        return FakerCreator.setDatabaseType(DatabaseType.H2);
    }

    private static FakerCreator setDatabaseType(DatabaseType dbType) {
        databaseType = dbType;
        return FakerCreatorHolder.INSTANCE;
    }

    public BaseFakerCreator url(String url) {
        switch (databaseType) {
            case MYSQL: {
                return MysqlFakerCreator.url(url);
            }
            case SQL_SERVER: {
                return SqlServerFakerCreator.url(url);
            }
            case ORACLE: {
                return OracleFakerCreator.url(url);
            }
            case SQLITE: {
                return SqliteFakerCreator.url(url);
            }
            case H2: {
                return H2FakerCreator.url(url);
            }
        }
        throw new RuntimeException("\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01");
    }

    public BaseFakerCreator dbName(String dbName) {
        switch (databaseType) {
            case MYSQL: {
                return MysqlFakerCreator.dbName(dbName);
            }
            case SQL_SERVER: {
                return SqlServerFakerCreator.dbName(dbName);
            }
            case ORACLE: {
                return OracleFakerCreator.dbName(dbName);
            }
            case SQLITE: {
                return SqliteFakerCreator.dbName(dbName);
            }
            case H2: {
                return H2FakerCreator.dbName(dbName);
            }
        }
        throw new RuntimeException("\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01");
    }

    private static final class FakerCreatorHolder {
        private static final FakerCreator INSTANCE = new FakerCreator();

        private FakerCreatorHolder() {
        }
    }
}

