/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net.loader.model;

import com.levylin.lib.net.loader.model.Model;
import java.util.List;

public abstract class ListModel<INFO, ITEM>
extends Model<INFO> {
    protected static int FIRST_PAGE = 1;
    protected int page = FIRST_PAGE;
    protected List<ITEM> mList;
    protected boolean isLoadMoreFromEnd = true;
    protected boolean hasNext = false;

    public ListModel(List<ITEM> list) {
        this.mList = list;
    }

    public void clear() {
        this.mList.clear();
    }

    public void preLoadNext() {
        ++this.page;
        this.cacheStrategy.setIsReadCache(false);
        this.cacheStrategy.setIsSaveCache(false);
    }

    @Override
    public void preRefresh() {
        super.preRefresh();
        this.page = FIRST_PAGE;
    }

    public int size() {
        return this.mList.size();
    }

    public int getPage() {
        return this.page;
    }

    @Override
    public void setData(boolean isRefreshing, INFO response) {
        if (this.page == FIRST_PAGE) {
            this.clear();
        }
        List<ITEM> mapList = this.map(response);
        this.hasNext = this.ensureHasNext(response, mapList);
        if (mapList == null) {
            return;
        }
        if (this.isLoadMoreFromEnd) {
            this.mList.addAll(mapList);
        } else {
            this.mList.addAll(0, mapList);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    protected abstract boolean ensureHasNext(INFO var1, List<ITEM> var2);

    protected abstract List<ITEM> map(INFO var1);
}

