/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net.loader;

import com.levylin.lib.net.INetworkView;
import com.levylin.lib.net.listener.OnLoadListener;
import com.levylin.lib.net.loader.DataLoader;
import com.levylin.lib.net.loader.helper.intf.IListViewHelper;
import com.levylin.lib.net.loader.helper.listener.OnLoadMoreListener;
import com.levylin.lib.net.loader.model.ListModel;

public class ListLoader<INFO, ITEM>
extends DataLoader<INFO>
implements OnLoadMoreListener {
    private ListModel<INFO, ITEM> model;
    private IListViewHelper mListViewHelper;

    public ListLoader(INetworkView view, ListModel<INFO, ITEM> listModel) {
        super(view, listModel);
        this.model = listModel;
    }

    public void setListViewHelper(IListViewHelper helper) {
        this.mListViewHelper = helper;
        this.mListViewHelper.setOnLoadMoreListener(this);
        this.mListViewHelper.setOnReLoadMoreListener(this);
    }

    @Override
    public void load() {
        this.cancel();
        this.mSubscription = this.model.load(new OnLoadListener<INFO>(){

            @Override
            public void onStart() {
                ListLoader.this.showLoading();
            }

            @Override
            public void onSuccess(INFO response) {
                ListLoader.this.showContent(response);
                ListLoader.this.model.setManualRefresh(false);
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                ListLoader.this.showError(throwable);
                ListLoader.this.model.setManualRefresh(false);
            }
        });
    }

    @Override
    public void onRefresh() {
        this.model.preRefresh();
        this.load();
    }

    @Override
    public void onLoadMore() {
        this.model.preLoadNext();
        this.load();
    }

    private void showLoading() {
        if (this.isRefreshing()) {
            return;
        }
        if (this.isLoadingMore()) {
            return;
        }
        if (this.mLoadStateViewHelper == null) {
            return;
        }
        this.mLoadStateViewHelper.showLoading();
    }

    private boolean isLoadingMore() {
        return this.mListViewHelper != null && this.mListViewHelper.isLoadingMore();
    }

    private void showContent(INFO responseModel) {
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(true);
        }
        this.model.setData(this.isRefreshing(), responseModel);
        if (this.mListViewHelper != null) {
            this.mListViewHelper.notifyAdapter();
        }
        this.setLoadMoreState(responseModel);
        if (this.mLoadStateViewHelper != null) {
            if (this.model.isEmpty()) {
                this.mLoadStateViewHelper.showEmpty();
            } else {
                this.mLoadStateViewHelper.showContent();
            }
        }
        if (this.onLoadSuccessListener != null) {
            this.onLoadSuccessListener.onSuccess(this.isRefreshing(), responseModel);
        }
    }

    private void setLoadMoreState(INFO response) {
        if (this.mListViewHelper == null) {
            return;
        }
        if (this.model.hasNext()) {
            this.mListViewHelper.showLoadMoreIdle();
        } else {
            this.mListViewHelper.showLoadMoreNoMore();
        }
    }

    private void showError(Throwable t) {
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(false);
        } else if (this.isLoadingMore()) {
            this.mListViewHelper.showLoadMoreError();
        } else if (this.mLoadStateViewHelper != null) {
            this.mLoadStateViewHelper.showError(this.model.isEmpty(), t);
        }
        if (this.onLoadFailureListener != null) {
            this.onLoadFailureListener.onFailure(this.isRefreshing(), t);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mListViewHelper = null;
    }
}

