/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net;

import com.levylin.lib.net.CacheStrategy;
import com.levylin.lib.net.NoCacheStrategy;
import com.levylin.lib.net.exception.ResponseException;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.io.IOException;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Response;

class RequestOnSubscribe<T>
implements FlowableOnSubscribe<T> {
    private Call<T> call;
    private boolean isNeedSaveCache;
    private CacheStrategy<T> cacheStrategy;

    RequestOnSubscribe(Call<T> call, CacheStrategy<T> strategy) {
        this.cacheStrategy = strategy;
        if (this.cacheStrategy == null) {
            this.cacheStrategy = new NoCacheStrategy();
        }
        this.call = call;
    }

    public void subscribe(FlowableEmitter<T> emitter) throws Exception {
        Request request = this.call.request();
        if (request.method().equalsIgnoreCase("POST")) {
            this.cacheStrategy.setIsReadCache(false);
            this.cacheStrategy.setIsSaveCache(false);
        }
        emitter.setCancellable(new Cancellable(){

            public void cancel() throws Exception {
                if (!RequestOnSubscribe.this.call.isCanceled()) {
                    RequestOnSubscribe.this.call.cancel();
                }
            }
        });
        this.isNeedSaveCache = this.ensureIsNeedSaveCache(request);
        if (!this.cacheStrategy.isReadCache()) {
            this.requestFromNet(emitter);
            this.cacheStrategy.reset();
            this.onComplete(emitter);
            return;
        }
        switch (this.cacheStrategy.getCacheType()) {
            case NO_CACHE: {
                this.requestFromNet(emitter);
                break;
            }
            case READ_CACHE_ONLY_NOT_EXPIRES: {
                this.requestReadCacheFirst(emitter);
                break;
            }
            case READ_CACHE_UPDATE_UI_THEN_NET_WHEN_EXPIRES: {
                this.requestReadCacheFirstAndNet(emitter);
                break;
            }
            case READ_CACHE_UPDATE_UI_THEN_NET: {
                this.requestReadCacheAndNet(emitter);
            }
        }
        this.cacheStrategy.reset();
        this.onComplete(emitter);
    }

    private boolean ensureIsNeedSaveCache(Request request) {
        return !request.method().equalsIgnoreCase("POST") && this.cacheStrategy.isSaveCache();
    }

    private void requestReadCacheFirst(FlowableEmitter<? super T> emitter) {
        T t = this.cacheStrategy.readCache();
        if (!this.cacheStrategy.isTimeOut() && t != null) {
            this.onNext(emitter, t);
        } else {
            this.requestFromNet(emitter);
        }
    }

    private void requestReadCacheFirstAndNet(FlowableEmitter<? super T> emitter) {
        T t = this.cacheStrategy.readCache();
        if (t != null) {
            this.onNext(emitter, t);
        }
        if (this.cacheStrategy.isTimeOut()) {
            this.requestFromNet(emitter);
        }
    }

    private void requestReadCacheAndNet(FlowableEmitter<? super T> emitter) {
        T t = this.cacheStrategy.readCache();
        if (t != null) {
            this.onNext(emitter, t);
        }
        this.requestFromNet(emitter);
    }

    private void requestFromNet(FlowableEmitter<? super T> emitter) {
        try {
            Response response;
            if (this.call.isExecuted()) {
                this.call = this.call.clone();
            }
            if ((response = this.call.execute()).isSuccessful() && response.body() != null) {
                Object t = response.body();
                if (this.isNeedSaveCache) {
                    this.cacheStrategy.saveCache(t);
                }
                this.onNext(emitter, t);
                return;
            }
            this.onError(emitter, new ResponseException(response));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onError(emitter, e);
        }
    }

    private void onNext(FlowableEmitter<? super T> emitter, T response) {
        if (emitter.isCancelled()) {
            return;
        }
        emitter.onNext(response);
    }

    private void onError(FlowableEmitter<? super T> emitter, Throwable throwable) {
        if (emitter.isCancelled()) {
            return;
        }
        emitter.onError(throwable);
    }

    private void onComplete(FlowableEmitter<? super T> emitter) {
        if (emitter.isCancelled()) {
            return;
        }
        emitter.onComplete();
    }
}

