/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.loader;

import com.levylin.loader.helper.intf.ILoadStateHelper;
import com.levylin.loader.helper.intf.IRefreshViewHelper;
import com.levylin.loader.helper.listener.OnRefreshListener;
import com.levylin.loader.helper.listener.OnReloadListener;
import com.levylin.loader.listener.OnLoadFailureListener;
import com.levylin.loader.listener.OnLoadListener;
import com.levylin.loader.listener.OnLoadSuccessListener;
import com.levylin.loader.model.IModel;

public class DataLoader<T> {
    ILoadStateHelper mLoadStateViewHelper;
    IRefreshViewHelper mRefreshViewHelper;
    OnLoadSuccessListener<T> onLoadSuccessListener;
    OnLoadFailureListener onLoadFailureListener;
    boolean isSilenceRefresh;
    private IModel<T> model;

    public DataLoader(IModel<T> model) {
        this.model = model;
    }

    public void setLoadStateHelper(ILoadStateHelper helper) {
        this.mLoadStateViewHelper = helper;
        this.mLoadStateViewHelper.setReloadListener(new OnReloadListener(){

            @Override
            public void onReLoad() {
                DataLoader.this.model.preReLoad();
                DataLoader.this.load();
            }
        });
    }

    public void setRefreshViewHelper(IRefreshViewHelper helper) {
        this.mRefreshViewHelper = helper;
        this.mRefreshViewHelper.setOnRefreshListener(new OnRefreshListener(){

            @Override
            public void onRefresh() {
                DataLoader.this.model.preRefresh();
                DataLoader.this.load();
            }
        });
    }

    public void setOnLoadSuccessListener(OnLoadSuccessListener<T> listener) {
        this.onLoadSuccessListener = listener;
    }

    public void setOnLoadFailureListener(OnLoadFailureListener listener) {
        this.onLoadFailureListener = listener;
    }

    public boolean isSilenceRefresh() {
        return this.isSilenceRefresh;
    }

    public void setSilenceRefresh(boolean isManualRefresh) {
        this.isSilenceRefresh = isManualRefresh;
    }

    public void load() {
        this.cancel();
        this.model.load(new OnLoadListener<T>(){

            @Override
            public void onStart() {
                DataLoader.this.showLoading();
            }

            @Override
            public void onSuccess(T response) {
                DataLoader.this.showContent(response);
                DataLoader.this.isSilenceRefresh = false;
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
                DataLoader.this.showError(throwable);
                DataLoader.this.isSilenceRefresh = false;
            }
        });
    }

    public void refresh() {
        this.isSilenceRefresh = true;
        this.model.preRefresh();
        this.load();
    }

    public void cancel() {
        this.model.cancel();
    }

    private void showLoading() {
        if (this.isRefreshing()) {
            return;
        }
        if (this.mLoadStateViewHelper == null) {
            return;
        }
        this.mLoadStateViewHelper.showLoading();
    }

    protected boolean isRefreshing() {
        return this.mRefreshViewHelper != null && this.mRefreshViewHelper.isRefreshing() || this.isSilenceRefresh;
    }

    private void showContent(T response) {
        if (this.isRefreshing() && this.mRefreshViewHelper != null) {
            this.mRefreshViewHelper.refreshComplete(true);
        }
        this.model.setData(this.isRefreshing(), response);
        if (this.mLoadStateViewHelper != null) {
            if (this.model.isEmpty()) {
                this.mLoadStateViewHelper.showEmpty();
            } else {
                this.mLoadStateViewHelper.showContent();
            }
        }
        if (this.onLoadSuccessListener != null) {
            this.onLoadSuccessListener.onSuccess(this.isRefreshing(), response);
        }
    }

    private void showError(Throwable t) {
        if (this.isRefreshing()) {
            if (this.mRefreshViewHelper != null) {
                this.mRefreshViewHelper.refreshComplete(false);
            }
        } else if (this.mLoadStateViewHelper != null) {
            this.mLoadStateViewHelper.showError(this.model.isEmpty(), t);
        }
        if (this.onLoadFailureListener != null) {
            this.onLoadFailureListener.onFailure(this.isRefreshing(), t);
        }
    }

    public void detachView() {
        this.cancel();
        this.mLoadStateViewHelper = null;
        this.mRefreshViewHelper = null;
    }
}

