/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.watermark;

import com.github.liaochong.myexcel.core.watermark.Watermark;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FontImage {
    public static BufferedImage createWatermarkImage(Watermark watermark) {
        BufferedImage image = new BufferedImage(watermark.getWidth(), watermark.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        image = g.getDeviceConfiguration().createCompatibleImage(watermark.getWidth(), watermark.getHeight(), 3);
        g.dispose();
        g = image.createGraphics();
        g.setColor(new Color(Integer.parseInt(watermark.getColor().substring(1), 16)));
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(watermark.getFont());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.rotate(-0.5, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        FontRenderContext context = g.getFontRenderContext();
        Rectangle2D bounds = watermark.getFont().getStringBounds(watermark.getText(), context);
        double x = ((double)watermark.getWidth() - bounds.getWidth()) / 2.0;
        double y = ((double)watermark.getHeight() - bounds.getHeight()) / 2.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        g.drawString(watermark.getText(), (int)x, (int)baseY);
        g.setComposite(AlphaComposite.getInstance(3));
        g.dispose();
        return image;
    }
}

