/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class BigDecimalWriteConverter
implements WriteConverter {
    @Override
    public boolean support(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        return fieldType == BigDecimal.class;
    }

    @Override
    public Pair<Class, Object> convert(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        if (!convertContext.isConvertCsv) {
            return Pair.of(Double.class, ((BigDecimal)fieldVal).toPlainString());
        }
        ExcelColumnMapping excelColumnMapping = convertContext.excelColumnMappingMap.get(field);
        String format = convertContext.configuration.decimalFormat;
        if (excelColumnMapping != null && !excelColumnMapping.format.isEmpty()) {
            format = excelColumnMapping.format;
        }
        if (format.isEmpty()) {
            return Pair.of(Double.class, ((BigDecimal)fieldVal).toPlainString());
        }
        String[] formatSplits = format.split("\\.");
        BigDecimal value = (BigDecimal)fieldVal;
        if (formatSplits.length == 2) {
            value = value.setScale(formatSplits[1].length(), RoundingMode.HALF_UP);
        }
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return Pair.of(String.class, decimalFormat.format(value));
    }
}

