/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClassFieldContainer {
    private Class<?> clazz;
    private List<Field> declaredFields = new ArrayList<Field>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private ClassFieldContainer parent;

    public Field getFieldByName(String fieldName) {
        return this.getFieldByName(fieldName, this);
    }

    public List<Field> getFieldsByAnnotation(Class<? extends Annotation> annotationClass) {
        Objects.requireNonNull(annotationClass);
        ArrayList<Field> annotationFields = new ArrayList<Field>();
        this.getFieldsByAnnotation(this, annotationClass, annotationFields);
        return annotationFields;
    }

    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getFieldsByContainer(this, fields);
        return fields;
    }

    private void getFieldsByContainer(ClassFieldContainer classFieldContainer, List<Field> fields) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByContainer(parentContainer, fields);
        }
        this.filterFields(classFieldContainer.getDeclaredFields(), fields);
    }

    private void getFieldsByAnnotation(ClassFieldContainer classFieldContainer, Class<? extends Annotation> annotationClass, List<Field> annotationFieldContainer) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByAnnotation(parentContainer, annotationClass, annotationFieldContainer);
        }
        List<Field> annotationFields = classFieldContainer.declaredFields.stream().filter(field -> field.isAnnotationPresent(annotationClass)).collect(Collectors.toList());
        this.filterFields(annotationFields, annotationFieldContainer);
    }

    private void filterFields(List<Field> declaredFields, List<Field> fieldContainer) {
        int size = declaredFields.size();
        block0: for (int i = 0; i < size; ++i) {
            Field field = declaredFields.get(i);
            for (int j = 0; j < fieldContainer.size(); ++j) {
                Field f = fieldContainer.get(j);
                if (!f.getName().equals(field.getName())) continue;
                fieldContainer.set(j, field);
                continue block0;
            }
            fieldContainer.add(field);
        }
    }

    private Field getFieldByName(String fieldName, ClassFieldContainer container) {
        Field field = container.getFieldMap().get(fieldName);
        if (field != null) {
            return field;
        }
        ClassFieldContainer parentContainer = container.getParent();
        if (parentContainer == null) {
            return null;
        }
        return this.getFieldByName(fieldName, parentContainer);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<Field> getDeclaredFields() {
        return this.declaredFields;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public ClassFieldContainer getParent() {
        return this.parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setDeclaredFields(List<Field> declaredFields) {
        this.declaredFields = declaredFields;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public void setParent(ClassFieldContainer parent) {
        this.parent = parent;
    }
}

