/*
 * Decompiled with CFR 0.152.
 */
package com.github.kxfeng.securepreferences;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.github.kxfeng.securepreferences.CiphertextIv;
import com.github.kxfeng.securepreferences.CryptoUtil;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class SecurePreferences
implements SharedPreferences {
    private static final String CIPHER_GCM_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int CIPHER_GCM_TAG_BIT_LENGTH = 128;
    private static final int CIPHER_GCM_IV_BIT_SIZE = 96;
    private static final int BASE64_FLAGS = 2;
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final String TAG = "SecurePreferences";
    private SharedPreferences mRawPrefs;
    private SecretKey mSecretKey;
    private byte[] mConstantKeyIv;

    public SecurePreferences(Context context, String name, SecretKey secretKey) {
        this.mRawPrefs = context.getSharedPreferences(name, 0);
        this.mSecretKey = secretKey;
        this.mConstantKeyIv = this.getConstantKeyIv(context);
    }

    public Map<String, ?> getAll() {
        Map all = this.mRawPrefs.getAll();
        HashMap<String, Object> decryptedAll = new HashMap<String, Object>();
        for (Map.Entry entry : all.entrySet()) {
            String decodedKey = this.decryptKey((String)entry.getKey());
            Object rawValue = entry.getValue();
            if (rawValue instanceof String) {
                decryptedAll.put(decodedKey, this.decryptValue((String)rawValue));
                continue;
            }
            if (!(rawValue instanceof Set)) continue;
            Set rawSet = (Set)rawValue;
            HashSet<String> decryptedSet = new HashSet<String>(rawSet.size());
            for (String text : rawSet) {
                decryptedSet.add(this.decryptValue(text));
            }
            decryptedAll.put(decodedKey, decryptedSet);
        }
        return decryptedAll;
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        String encrypted = this.mRawPrefs.getString(this.encryptKey(key), null);
        String value = this.decryptValue(encrypted);
        return value == null ? defValue : value;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        Set encryptedSet = this.mRawPrefs.getStringSet(this.encryptKey(key), null);
        HashSet<String> values = null;
        if (encryptedSet != null) {
            values = new HashSet<String>(encryptedSet.size());
            for (String text : encryptedSet) {
                values.add(this.decryptValue(text));
            }
        }
        return values == null ? defValues : values;
    }

    public int getInt(String key, int defValue) {
        String encrypted = this.mRawPrefs.getString(this.encryptKey(key), null);
        String value = this.decryptValue(encrypted);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defValue;
        }
    }

    public long getLong(String key, long defValue) {
        String encrypted = this.mRawPrefs.getString(this.encryptKey(key), null);
        String value = this.decryptValue(encrypted);
        if (value == null) {
            return defValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defValue;
        }
    }

    public float getFloat(String key, float defValue) {
        String encrypted = this.mRawPrefs.getString(this.encryptKey(key), null);
        String value = this.decryptValue(encrypted);
        if (value == null) {
            return defValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return defValue;
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        String encrypted = this.mRawPrefs.getString(this.encryptKey(key), null);
        String value = this.decryptValue(encrypted);
        if (value == null) {
            return defValue;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException ex) {
            return defValue;
        }
    }

    public boolean contains(String key) {
        return this.mRawPrefs.contains(this.encryptKey(key));
    }

    public Editor edit() {
        return new Editor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mRawPrefs.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mRawPrefs.unregisterOnSharedPreferenceChangeListener(listener);
    }

    private String encryptKey(@Nullable String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        try {
            byte[] encrypted = this.encrypt(text.getBytes(CHARSET_UTF8), this.mConstantKeyIv);
            return Base64.encodeToString((byte[])encrypted, (int)2);
        }
        catch (GeneralSecurityException ex) {
            Log.w((String)TAG, (String)("encryptKey error:" + ex));
            return null;
        }
    }

    private String decryptKey(@Nullable String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        try {
            byte[] decode = Base64.decode((byte[])text.getBytes(CHARSET_UTF8), (int)2);
            byte[] decrypted = this.decrypt(decode, this.mConstantKeyIv);
            return new String(decrypted, CHARSET_UTF8);
        }
        catch (IllegalArgumentException | GeneralSecurityException ex) {
            Log.w((String)TAG, (String)("decryptKey error:" + ex));
            return null;
        }
    }

    @Nullable
    private String encryptValue(@Nullable String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        try {
            byte[] iv = CryptoUtil.randomBytes(12);
            byte[] encrypted = this.encrypt(text.getBytes(CHARSET_UTF8), iv);
            return new CiphertextIv(encrypted, iv).toString();
        }
        catch (GeneralSecurityException ex) {
            Log.w((String)TAG, (String)("encryptValue error:" + ex));
            return null;
        }
    }

    @Nullable
    private String decryptValue(@Nullable String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        try {
            CiphertextIv ciphertextIv = new CiphertextIv(text);
            byte[] decrypted = this.decrypt(ciphertextIv.ciphertext, ciphertextIv.iv);
            return new String(decrypted, CHARSET_UTF8);
        }
        catch (GeneralSecurityException ex) {
            Log.w((String)TAG, (String)("decryptValue error:" + ex));
            return null;
        }
    }

    private byte[] encrypt(@NonNull byte[] data, @NonNull byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_GCM_TRANSFORMATION);
        AlgorithmParameterSpec gcmParameterSpec = CryptoUtil.getGcmParameterSpec(iv, 128);
        cipher.init(1, (Key)this.mSecretKey, gcmParameterSpec);
        return cipher.doFinal(data);
    }

    private byte[] decrypt(@NonNull byte[] data, @NonNull byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_GCM_TRANSFORMATION);
        AlgorithmParameterSpec gcmParameterSpec = CryptoUtil.getGcmParameterSpec(iv, 128);
        cipher.init(2, (Key)this.mSecretKey, gcmParameterSpec);
        return cipher.doFinal(data);
    }

    private byte[] getConstantKeyIv(Context context) {
        byte[] ids = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").getBytes(CHARSET_UTF8);
        return Arrays.copyOf(ids, 12);
    }

    public class Editor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor mEditor;

        @SuppressLint(value={"CommitPrefEdits"})
        Editor() {
            this.mEditor = SecurePreferences.this.mRawPrefs.edit();
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            this.mEditor.putString(SecurePreferences.this.encryptKey(key), SecurePreferences.this.encryptValue(value));
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            HashSet<String> encryptSet = null;
            if (values != null) {
                encryptSet = new HashSet<String>(values.size());
                for (String text : values) {
                    encryptSet.add(SecurePreferences.this.encryptValue(text));
                }
            }
            this.mEditor.putStringSet(SecurePreferences.this.encryptKey(key), encryptSet);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.mEditor.putString(SecurePreferences.this.encryptKey(key), SecurePreferences.this.encryptValue(Integer.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.mEditor.putString(SecurePreferences.this.encryptKey(key), SecurePreferences.this.encryptValue(Long.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.mEditor.putString(SecurePreferences.this.encryptKey(key), SecurePreferences.this.encryptValue(Float.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.mEditor.putString(SecurePreferences.this.encryptKey(key), SecurePreferences.this.encryptValue(Boolean.toString(value)));
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mEditor.remove(SecurePreferences.this.encryptKey(key));
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.mEditor.clear();
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        public void apply() {
            this.mEditor.apply();
        }
    }
}

