/*
 * Decompiled with CFR 0.152.
 */
package com.github.kubode.rx.android.schedulers;

import android.os.Looper;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class ImmediateLooperScheduler
extends Scheduler {
    public static final ImmediateLooperScheduler MAIN = new ImmediateLooperScheduler(Looper.getMainLooper());
    private final Looper looper;
    private final Scheduler looperScheduler;
    private final Scheduler immediateScheduler;

    public ImmediateLooperScheduler(Looper looper) {
        this.looper = looper;
        this.looperScheduler = AndroidSchedulers.from((Looper)looper);
        this.immediateScheduler = Schedulers.trampoline();
    }

    public Scheduler.Worker createWorker() {
        return new ImmediatelyWorker(this.looper, this.looperScheduler.createWorker(), this.immediateScheduler.createWorker());
    }

    private static class ImmediatelyWorker
    extends Scheduler.Worker {
        private final Looper looper;
        private final Scheduler.Worker looperWorker;
        private final Scheduler.Worker immediateWorker;
        private final Disposable disposable;

        private ImmediatelyWorker(Looper looper, Scheduler.Worker looperWorker, Scheduler.Worker immediateWorker) {
            this.looper = looper;
            this.looperWorker = looperWorker;
            this.immediateWorker = immediateWorker;
            this.disposable = new CompositeDisposable(new Disposable[]{looperWorker, immediateWorker});
        }

        private Scheduler.Worker getWorker() {
            if (Looper.myLooper() == this.looper) {
                return this.immediateWorker;
            }
            return this.looperWorker;
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            return this.getWorker().schedule(run, delay, unit);
        }

        public void dispose() {
            this.disposable.dispose();
        }

        public boolean isDisposed() {
            return this.disposable.isDisposed();
        }
    }
}

