/*
 * Decompiled with CFR 0.152.
 */
package ki.pagetransformer.sharedelement;

import android.app.Activity;
import android.graphics.Point;
import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedElementPageTransformer
implements ViewPager.PageTransformer,
ViewPager.OnPageChangeListener {
    private static float MAGICAL_ANDROID_RENDERING_SCALE = 1.0f;
    private final Activity activity;
    List<Fragment> fragments;
    private Set<Pair<Integer, Integer>> sharedElementIds = new HashSet<Pair<Integer, Integer>>();
    private List<View> pages;
    private Map<View, Integer> pageToNumber = new HashMap<View, Integer>();
    private Integer fromPageNumber = 0;
    private Integer toPageNumber;
    private int position;

    public SharedElementPageTransformer(Activity activity, List<Fragment> fragments) {
        this.activity = activity;
        this.fragments = fragments;
    }

    public void transformPage(@NonNull View page, float position) {
        this.updatePageCache();
        if (this.fromPageNumber == null || this.toPageNumber == null) {
            return;
        }
        for (Pair<Integer, Integer> idPair : this.sharedElementIds) {
            float scaleY;
            float scaleX;
            boolean slideToTheRight;
            Integer fromViewId = (Integer)idPair.first;
            Integer toViewId = (Integer)idPair.second;
            View fromView = this.activity.findViewById(fromViewId.intValue());
            View toView = this.activity.findViewById(toViewId.intValue());
            if (fromView == null || toView == null) continue;
            View fromPage = this.pages.get(this.fromPageNumber);
            View toPage = this.pages.get(this.toPageNumber);
            if (fromPage == null || toPage == null) continue;
            fromView = fromPage.findViewById(fromViewId.intValue());
            toView = toPage.findViewById(toViewId.intValue());
            if (fromView == null || toView == null) continue;
            float fromX = fromView.getX() - fromView.getTranslationX();
            float fromY = fromView.getY() - fromView.getTranslationY();
            float toX = toView.getX() - toView.getTranslationX();
            float toY = toView.getY() - toView.getTranslationY();
            float deltaX = toX - fromX;
            float deltaY = toY - fromY;
            float fromWidth = fromView.getWidth();
            float fromHeight = fromView.getHeight();
            float toWidth = toView.getWidth();
            float toHeight = toView.getHeight();
            float deltaWidth = toWidth - fromWidth;
            float deltaHeight = toHeight - fromHeight;
            int fromId = fromView.getId();
            int toId = toView.getId();
            boolean bl = slideToTheRight = this.toPageNumber > this.fromPageNumber;
            if (position <= -1.0f || !(position < 1.0f)) continue;
            float pageWidth = this.getSceenWidth();
            float sign = slideToTheRight ? 1.0f : -1.0f;
            float translationY = (deltaY + deltaHeight / 2.0f) * sign * -position;
            float translationX = (deltaX + sign * pageWidth + deltaWidth / 2.0f) * sign * -position;
            if (page.findViewById(fromId) != null) {
                fromView.setTranslationX(translationX);
                fromView.setTranslationY(translationY);
                scaleX = fromWidth == 0.0f ? 1.0f : (fromWidth + deltaWidth * sign * -position) / fromWidth;
                scaleY = fromHeight == 0.0f ? 1.0f : (fromHeight + deltaHeight * sign * -position) / fromHeight;
                fromView.setScaleX(scaleX);
                fromView.setScaleY(scaleY * MAGICAL_ANDROID_RENDERING_SCALE);
            }
            if (page.findViewById(toId) == null) continue;
            toView.setTranslationX(translationX);
            toView.setTranslationY(translationY);
            scaleX = toWidth == 0.0f ? 1.0f : (toWidth + deltaWidth * sign * -position) / toWidth;
            scaleY = toHeight == 0.0f ? 1.0f : (toHeight + deltaHeight * sign * -position) / toHeight;
            toView.setScaleX(scaleX);
            toView.setScaleY(scaleY);
        }
    }

    private float getSceenWidth() {
        Point outSize = new Point();
        this.activity.getWindowManager().getDefaultDisplay().getSize(outSize);
        return outSize.x;
    }

    private void updatePageCache() {
        this.pages = new ArrayList<View>();
        for (int i = 0; i < this.fragments.size(); ++i) {
            View pageView = this.fragments.get(i).getView();
            this.pages.add(pageView);
            this.pageToNumber.put(pageView, i);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        HashSet<Integer> visiblePages = new HashSet<Integer>();
        visiblePages.add(position);
        visiblePages.add(positionOffset >= 0.0f ? position + 1 : position - 1);
        visiblePages.remove(this.fromPageNumber);
        this.toPageNumber = (Integer)visiblePages.iterator().next();
        if (this.pages == null || this.toPageNumber >= this.pages.size()) {
            this.toPageNumber = null;
        }
    }

    public void onPageSelected(int position) {
        this.position = position;
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.fromPageNumber = this.position;
            this.resetViewPositions();
        }
    }

    private void resetViewPositions() {
        for (Pair<Integer, Integer> idPair : this.sharedElementIds) {
            View sharedElement = this.activity.findViewById(((Integer)idPair.first).intValue());
            if (sharedElement != null) {
                sharedElement.setTranslationX(0.0f);
                sharedElement.setTranslationY(0.0f);
                sharedElement.setScaleX(1.0f);
                sharedElement.setScaleY(1.0f);
            }
            if ((sharedElement = this.activity.findViewById(((Integer)idPair.second).intValue())) == null) continue;
            sharedElement.setTranslationX(0.0f);
            sharedElement.setTranslationY(0.0f);
            sharedElement.setScaleX(1.0f);
            sharedElement.setScaleY(1.0f);
        }
    }

    public void addSharedTransition(int fromViewId, int toViewId) {
        this.addSharedTransition(fromViewId, toViewId, false);
    }

    public void addSharedTransition(int fromViewId, int toViewId, boolean bothDirections) {
        this.sharedElementIds.add((Pair<Integer, Integer>)new Pair((Object)fromViewId, (Object)toViewId));
        if (bothDirections) {
            this.sharedElementIds.add((Pair<Integer, Integer>)new Pair((Object)toViewId, (Object)fromViewId));
        }
    }

    public static void setMagicalAndroidRenderingScale(float magicalAndroidRenderingScale) {
        MAGICAL_ANDROID_RENDERING_SCALE = magicalAndroidRenderingScale;
    }
}

