/*
 * Decompiled with CFR 0.152.
 */
package com.github.kayvannj.permission_utils;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.github.kayvannj.permission_utils.Func;
import com.github.kayvannj.permission_utils.Func2;
import com.github.kayvannj.permission_utils.SinglePermission;
import java.util.ArrayList;

public class PermissionUtil {
    public static final int REQ_CODE_ALL_GRANTED = -1;
    private static final String TAG = PermissionUtil.class.getSimpleName();
    private static AppCompatActivity mAppCompatActivity;

    public static PermissionObject with(AppCompatActivity activity) {
        mAppCompatActivity = activity;
        return new PermissionObject();
    }

    public static class PermissionRequestObject {
        private static final String TAG = PermissionObject.class.getSimpleName();
        private ArrayList<SinglePermission> mPermissionsWeDontHave;
        private int mRequestCode;
        private Func mRationalFunc;
        private Func mGrantFunc;
        private Func mDenyFunc;
        private Func2 mResultFunc;
        private String[] mPermissionNames;

        public PermissionRequestObject(String[] permissionNames) {
            this.mPermissionNames = permissionNames;
        }

        public PermissionRequestObject ask(int reqCode) {
            this.mRequestCode = reqCode;
            int length = this.mPermissionNames.length;
            this.mPermissionsWeDontHave = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                this.mPermissionsWeDontHave.add(new SinglePermission(this.mPermissionNames[i]));
            }
            if (this.needToAsk()) {
                Log.i((String)TAG, (String)"Asking for permission");
                ActivityCompat.requestPermissions((Activity)mAppCompatActivity, (String[])this.mPermissionNames, (int)reqCode);
            } else {
                Log.i((String)TAG, (String)"No need to ask for permission");
                if (this.mGrantFunc != null) {
                    this.mGrantFunc.call();
                }
            }
            return this;
        }

        private boolean needToAsk() {
            int i;
            ArrayList<SinglePermission> neededPermissions = new ArrayList<SinglePermission>(this.mPermissionsWeDontHave);
            for (i = 0; i < this.mPermissionsWeDontHave.size(); ++i) {
                SinglePermission perm = this.mPermissionsWeDontHave.get(i);
                int checkRes = ContextCompat.checkSelfPermission((Context)mAppCompatActivity, (String)perm.getPermissionName());
                if (checkRes == 0) {
                    neededPermissions.remove(perm);
                    continue;
                }
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)mAppCompatActivity, (String)perm.getPermissionName())) continue;
                perm.setRationalNeeded(true);
            }
            this.mPermissionsWeDontHave = neededPermissions;
            this.mPermissionNames = new String[this.mPermissionsWeDontHave.size()];
            for (i = 0; i < this.mPermissionsWeDontHave.size(); ++i) {
                this.mPermissionNames[i] = this.mPermissionsWeDontHave.get(i).getPermissionName();
            }
            return this.mPermissionsWeDontHave.size() != 0;
        }

        public PermissionRequestObject onRational(Func rationalFunc) {
            this.mRationalFunc = rationalFunc;
            return this;
        }

        public PermissionRequestObject onAllGranted(Func grantFunc) {
            this.mGrantFunc = grantFunc;
            return this;
        }

        public PermissionRequestObject onAllDenied(Func denyFunc) {
            this.mDenyFunc = denyFunc;
            return this;
        }

        public PermissionRequestObject onResult(Func2 resultFunc) {
            this.mResultFunc = resultFunc;
            return this;
        }

        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            Log.i((String)TAG, (String)String.format("ReqCode: %d, ResCode: %d, PermissionName: %s", requestCode, grantResults[0], permissions[0]));
            if (this.mRequestCode == requestCode) {
                if (this.mResultFunc != null) {
                    Log.i((String)TAG, (String)"Calling Results Func");
                    this.mResultFunc.call(requestCode, permissions, grantResults);
                    return;
                }
                for (int i = 0; i < permissions.length; ++i) {
                    if (grantResults[i] != -1) continue;
                    if (this.mPermissionsWeDontHave.get(i).isRationalNeeded() && this.mRationalFunc != null) {
                        Log.i((String)TAG, (String)"Calling Rational Func");
                        this.mRationalFunc.call();
                    }
                    if (this.mDenyFunc != null) {
                        Log.i((String)TAG, (String)"Calling Deny Func");
                        this.mDenyFunc.call();
                    } else {
                        Log.e((String)TAG, (String)"NUll DENY FUNCTIONS");
                    }
                    return;
                }
                if (this.mGrantFunc != null) {
                    Log.i((String)TAG, (String)"Calling Grant Func");
                    this.mGrantFunc.call();
                } else {
                    Log.e((String)TAG, (String)"NUll GRANT FUNCTIONS");
                }
            }
        }
    }

    public static class PermissionObject {
        public PermissionRequestObject request(String permissionName) {
            return new PermissionRequestObject(new String[]{permissionName});
        }

        public PermissionRequestObject request(String ... permissionNames) {
            return new PermissionRequestObject(permissionNames);
        }
    }
}

