/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.github.karthyks.runtimepermissions.PermissionUtil;
import com.github.karthyks.runtimepermissions.R;
import com.github.karthyks.runtimepermissions.prefs.SharedPrefUtil;

public class PermissionActivity
extends AppCompatActivity {
    public static final String TAG = PermissionActivity.class.getSimpleName();
    public static final String EXTRAS_PERMISSION_CODE = "extras_request_code";
    public static final String EXTRAS_PERMISSIONS = "extras_permissions";
    public static final String EXTRAS_RATIONALE = "extras_rationale";
    public static final int REQUEST_PERMISSION_CODE = 4096;
    public static final int PERMISSION_GRANTED = 101;
    public static final int PERMISSION_DENIED = 102;
    public static final int PERMISSION_PERMANENTLY_DENIED = 103;
    private CoordinatorLayout layoutParent;
    private int permissionCode;
    private String[] permissions;
    private String rationaleDialog;
    private boolean shouldShowRationale = false;

    public static Intent getInstance(Context context, int permissionCode, String[] permissions, String rationale) {
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(EXTRAS_PERMISSION_CODE, permissionCode);
        intent.putExtra(EXTRAS_PERMISSIONS, permissions);
        intent.putExtra(EXTRAS_RATIONALE, rationale);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_run_time_permission);
        this.layoutParent = (CoordinatorLayout)this.findViewById(R.id.layout_permission);
        this.permissionCode = this.getIntent().getIntExtra(EXTRAS_PERMISSION_CODE, -1);
        this.permissions = this.getIntent().getStringArrayExtra(EXTRAS_PERMISSIONS);
        this.rationaleDialog = this.getIntent().getStringExtra(EXTRAS_RATIONALE);
        boolean isGranted = false;
        for (String permission2 : this.permissions) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)permission2) != 0) {
                this.checkPermission();
                break;
            }
            isGranted = true;
        }
        if (isGranted) {
            this.endActivity(101);
        }
    }

    private void checkPermission() {
        for (String permission2 : this.permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission2)) continue;
            this.shouldShowRationale = true;
        }
        if (this.shouldShowRationale) {
            Snackbar.make((View)this.layoutParent, (CharSequence)this.rationaleDialog, (int)-2).setAction(17039370, new View.OnClickListener(){

                public void onClick(View view) {
                    ActivityCompat.requestPermissions((Activity)PermissionActivity.this, (String[])PermissionActivity.this.permissions, (int)PermissionActivity.this.permissionCode);
                }
            }).setActionTextColor(ContextCompat.getColor((Context)this, (int)17170447)).show();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)this.permissionCode);
        }
    }

    private void endActivity(int result) {
        this.setResult(result);
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == this.permissionCode) {
            if (PermissionUtil.verifyPermissions(grantResults)) {
                this.endActivity(101);
            } else if (!SharedPrefUtil.isDeniedOnce((Context)this, this.permissionCode)) {
                SharedPrefUtil.putInSharedPref((Context)this, this.permissionCode, true);
                this.endActivity(102);
            } else {
                boolean permanentlyDenied = false;
                for (String permission2 : permissions) {
                    if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission2)) continue;
                    permanentlyDenied = true;
                }
                if (permanentlyDenied) {
                    this.endActivity(103);
                } else {
                    this.endActivity(102);
                }
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}

