/*
 * Decompiled with CFR 0.152.
 */
package com.kapil.circularlayoutmanager;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.kapil.circularlayoutmanager.CircularLayoutManager;
import com.kapil.circularlayoutmanager.OnItemClickListener;
import com.kapil.circularlayoutmanager.Utils;

public class ScrollWheel
extends View
implements GestureDetector.OnGestureListener {
    private GestureDetector gestureDetector;
    private RecyclerView recyclerView;
    private OnItemClickListener onItemClickListener;
    private boolean scrollWheelEnabled;
    private boolean consumeTouchOutsideTouchAreaEnabled;
    private int xCenter;
    private int yCenter;
    private int innerRadius;
    private int outerRadius;
    private int touchAreaThickness;
    private boolean touchInitiatedBetweenCircles;
    private Paint touchAreaPaint;
    private boolean highlightTouchAreaEnabled;

    public ScrollWheel(Context context) {
        super(context);
        this.init();
    }

    public ScrollWheel(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ScrollWheel(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.scrollWheelEnabled = true;
        this.consumeTouchOutsideTouchAreaEnabled = true;
        this.touchAreaThickness = -1;
        this.touchAreaPaint = new Paint();
        this.touchAreaPaint.setAntiAlias(true);
        this.touchAreaPaint.setStyle(Paint.Style.STROKE);
        this.touchAreaPaint.setColor(Color.parseColor((String)"#50FF0000"));
        this.highlightTouchAreaEnabled = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.xCenter = this.getMeasuredWidth() / 2;
        this.yCenter = this.getMeasuredHeight() / 2;
        int minDimension = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        this.outerRadius = minDimension / 2;
        this.innerRadius = this.touchAreaThickness == -1 ? minDimension / 4 : this.outerRadius - this.touchAreaThickness;
        this.touchAreaPaint.setStrokeWidth((float)(this.outerRadius - this.innerRadius));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.highlightTouchAreaEnabled) {
            canvas.drawCircle((float)this.xCenter, (float)this.yCenter, (float)((this.innerRadius + this.outerRadius) / 2), this.touchAreaPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.recyclerView == null || !this.scrollWheelEnabled) {
            return super.onTouchEvent(event);
        }
        if (event.getActionMasked() == 1) {
            ((CircularLayoutManager)this.recyclerView.getLayoutManager()).stabilize();
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent e) {
        float y;
        float x = e.getX();
        this.touchInitiatedBetweenCircles = (x - (float)this.xCenter) * (x - (float)this.xCenter) + ((y = e.getY()) - (float)this.yCenter) * (y - (float)this.yCenter) > (float)(this.innerRadius * this.innerRadius) && (x - (float)this.xCenter) * (x - (float)this.xCenter) + (y - (float)this.yCenter) * (y - (float)this.yCenter) < (float)(this.outerRadius * this.outerRadius);
        return this.consumeTouchOutsideTouchAreaEnabled || this.touchInitiatedBetweenCircles;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        int childIndex;
        if (this.onItemClickListener != null && this.consumeTouchOutsideTouchAreaEnabled && (childIndex = this.getChildIndexUnder(e.getX(), e.getY())) != -1) {
            this.onItemClickListener.onItemClick(this, childIndex);
        }
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.touchInitiatedBetweenCircles) {
            return false;
        }
        int delta = 0;
        float x = e2.getX();
        float y = e2.getY();
        if (x <= (float)this.xCenter && y < (float)this.yCenter) {
            delta = (int)(distanceX - distanceY);
        } else if (x > (float)this.xCenter && y <= (float)this.yCenter) {
            delta = (int)(distanceX + distanceY);
        } else if (x >= (float)this.xCenter && y > (float)this.yCenter) {
            delta = (int)(-distanceX + distanceY);
        } else if (x < (float)this.xCenter && y >= (float)this.yCenter) {
            delta = (int)(-distanceX - distanceY);
        }
        this.recyclerView.scrollBy(0, delta);
        return true;
    }

    public void onLongPress(MotionEvent e) {
        int childIndex;
        if (this.onItemClickListener != null && this.consumeTouchOutsideTouchAreaEnabled && (childIndex = this.getChildIndexUnder(e.getX(), e.getY())) != -1) {
            this.onItemClickListener.onItemLongClick(this, childIndex);
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.touchInitiatedBetweenCircles) {
            return false;
        }
        int delta = 0;
        float x = e2.getX();
        float y = e2.getY();
        if (x <= (float)this.xCenter && y < (float)this.yCenter) {
            delta = (int)(velocityX - velocityY);
        } else if (x > (float)this.xCenter && y <= (float)this.yCenter) {
            delta = (int)(velocityX + velocityY);
        } else if (x >= (float)this.xCenter && y > (float)this.yCenter) {
            delta = (int)(-velocityX + velocityY);
        } else if (x < (float)this.xCenter && y >= (float)this.yCenter) {
            delta = (int)(-velocityX - velocityY);
        }
        this.recyclerView.fling(0, -delta);
        return true;
    }

    private int getChildIndexUnder(float x, float y) {
        View child = this.recyclerView.findChildViewUnder(x, y);
        if (child != null) {
            return this.recyclerView.indexOfChild(child);
        }
        return -1;
    }

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public boolean isScrollWheelEnabled() {
        return this.scrollWheelEnabled;
    }

    public void setScrollWheelEnabled(boolean scrollWheelEnabled) {
        this.scrollWheelEnabled = scrollWheelEnabled;
    }

    public boolean isConsumeTouchOutsideTouchAreaEnabled() {
        return this.consumeTouchOutsideTouchAreaEnabled;
    }

    public void setConsumeTouchOutsideTouchAreaEnabled(boolean consumeTouchOutsideTouchAreaEnabled) {
        this.consumeTouchOutsideTouchAreaEnabled = consumeTouchOutsideTouchAreaEnabled;
    }

    public int getTouchAreaThickness() {
        return this.touchAreaThickness;
    }

    public void setTouchAreaThickness(int thickness) {
        this.touchAreaThickness = (int)Utils.dpToPx(this.getContext(), thickness);
        this.invalidate();
    }

    public int getTouchAreaColor() {
        return this.touchAreaPaint.getColor();
    }

    public void setTouchAreaColor(int touchAreaColor) {
        this.touchAreaPaint.setColor(touchAreaColor);
        this.invalidate();
    }

    public boolean isHighlightTouchAreaEnabled() {
        return this.highlightTouchAreaEnabled;
    }

    public void setHighlightTouchAreaEnabled(boolean highlightTouchAreaEnabled) {
        this.highlightTouchAreaEnabled = highlightTouchAreaEnabled;
        this.invalidate();
    }
}

