/*
 * Decompiled with CFR 0.152.
 */
package com.jsmeli.permissioncheck.sjml;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.Fragment;
import com.jsmeli.permissioncheck.sjml.PermissionCallBack;
import com.jsmeli.permissioncheck.sjml.util.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionCheck {
    private Object obj;
    private int requestCode;
    private static boolean cue;
    private String[] permissions;
    private static PermissionCallBack callBack;
    public static final int PERMISSION_CHECK_SUCCESS = 1;
    public static final int PERMISSION_CHECK_FAILED = 2;
    public static final int PERMISSION_CHECK_CUE = 0;

    private PermissionCheck(Object object) {
        this.obj = object;
    }

    public static PermissionCheck with(Activity activity) {
        return new PermissionCheck(activity);
    }

    public static PermissionCheck with(Fragment fragment) {
        return new PermissionCheck(fragment);
    }

    public PermissionCheck setRequestCodeAndisCue(int requestCode, boolean cue) {
        this.requestCode = requestCode;
        PermissionCheck.cue = cue;
        return this;
    }

    public PermissionCheck needPermission(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    public PermissionCheck callback(PermissionCallBack permissionCallBack) {
        callBack = permissionCallBack;
        return this;
    }

    @TargetApi(value=23)
    public void check() {
        PermissionCheck.requestPermissions(this.obj, this.requestCode, this.permissions);
    }

    @TargetApi(value=23)
    private static void requestPermissions(final Object object, int requestCode, String[] permissions) {
        if (!PermissionUtils.isOverMarshmallow()) {
            callBack.applyResult(requestCode, 1);
            return;
        }
        if (permissions.length > 1) {
            List<String> applyPermissions = PermissionUtils.checkPermission(PermissionUtils.getActivity(object), permissions);
            if (applyPermissions.size() > 0) {
                PermissionCheck.applyPermission(object, applyPermissions, requestCode);
            } else {
                callBack.applyResult(requestCode, 1);
            }
        } else if (permissions.length == 1) {
            int ret = PermissionUtils.checkSinglePermission(PermissionUtils.getActivity(object), permissions[0]);
            if (ret == 2) {
                PermissionCheck.applyPermission(object, Arrays.asList(permissions), requestCode);
            } else if (ret == 0) {
                if (cue) {
                    new AlertDialog.Builder((Context)PermissionUtils.getActivity(object)).setTitle((CharSequence)"\ufffd\ufffd\u0730\ufffd\ufffd\u02be").setMessage((CharSequence)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u0221\ufffd\u6d22\ufffd\u057c\u48ec\u03aa\ufffd\ufffd\ufffd\u6d22\ufffd\ufffd\ufffd\ufffd\ufffd\u03e2\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u04e6\ufffd\u00fd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd").setCancelable(false).setPositiveButton((CharSequence)"\u0225\ufffd\ufffd\ufffd\ufffd", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                            intent.setData(Uri.fromParts((String)"package", (String)PermissionUtils.getActivity(object).getPackageName(), null));
                            PermissionUtils.getActivity(object).startActivity(intent);
                        }
                    }).create().show();
                }
                callBack.applyResult(requestCode, 0);
            } else {
                callBack.applyResult(requestCode, 1);
            }
        }
    }

    @TargetApi(value=23)
    public static void applyPermission(Object object, List<String> applyPermissions, int requestCode) {
        if (object instanceof Activity) {
            ((Activity)object).requestPermissions(applyPermissions.toArray(new String[applyPermissions.size()]), requestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).requestPermissions(applyPermissions.toArray(new String[applyPermissions.size()]), requestCode);
        } else {
            throw new IllegalArgumentException(object.getClass().getName() + " is incorrect , please check the calling location");
        }
    }

    public static void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        PermissionCheck.requestResult(activity, requestCode, permissions, grantResults);
    }

    public static void onRequestPermissionsResult(Fragment fragment, int requestCode, String[] permissions, int[] grantResults) {
        PermissionCheck.requestResult(fragment, requestCode, permissions, grantResults);
    }

    private static void requestResult(final Object obj, final int requestCode, final String[] permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] == 0) continue;
            deniedPermissions.add(permissions[i]);
        }
        if (deniedPermissions.size() > 0) {
            if (permissions.length == 1) {
                int ret = PermissionUtils.checkSinglePermission(PermissionUtils.getActivity(obj), permissions[0]);
                if (ret == 0) {
                    if (cue) {
                        new AlertDialog.Builder((Context)PermissionUtils.getActivity(obj)).setTitle((CharSequence)"\ufffd\ufffd\u0730\ufffd\ufffd\u02be").setMessage((CharSequence)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u0221\ufffd\u6d22\ufffd\u057c\u48ec\u03aa\ufffd\ufffd\ufffd\u6d22\ufffd\ufffd\ufffd\ufffd\ufffd\u03e2\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u04e6\ufffd\u00fd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd").setCancelable(false).setPositiveButton((CharSequence)"\u0225\ufffd\ufffd\ufffd\ufffd", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                                intent.setData(Uri.fromParts((String)"package", (String)PermissionUtils.getActivity(obj).getPackageName(), null));
                                PermissionUtils.getActivity(obj).startActivity(intent);
                            }
                        }).create().show();
                    }
                    callBack.applyResult(requestCode, 0);
                } else if (ret == 2) {
                    if (cue) {
                        new AlertDialog.Builder((Context)PermissionUtils.getActivity(obj)).setTitle((CharSequence)"\ufffd\ufffd\u0730\ufffd\ufffd\u02be").setMessage((CharSequence)"\ufffd\ufffd\ufffd\ufffd\ufffd\udabe\udeb4\u6d22\u0228\ufffd\u07a3\ufffd\ufffd\ufffd\ufffd\ufffd\u04f0\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u02b9\ufffd\ufffd!").setCancelable(false).setPositiveButton((CharSequence)"\u0237\ufffd\ufffd", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                                PermissionCheck.applyPermission(obj, Arrays.asList(permissions), requestCode);
                            }
                        }).create().show();
                    }
                    callBack.applyResult(requestCode, 2);
                }
            } else {
                callBack.applyResult(requestCode, 2);
            }
        } else {
            callBack.applyResult(requestCode, 1);
        }
    }
}

