/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrubygradle.internal;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.webapp.WebAppContext;

public class RubygemsServlet {
    private final Server server = new Server();
    private final StdErrLog log = new StdErrLog();
    private final ServerConnector connector;
    private final HandlerCollection handlerCollection = new HandlerCollection();
    private final File cachedir;
    private final String rubygemsWarURI;
    private boolean enabledLogging = true;
    private Set<String> urls = new HashSet<String>();

    public static RubygemsServlet create(URL url) {
        return new RubygemsServlet(url);
    }

    public RubygemsServlet(URL rubygemsWarURL) {
        this.rubygemsWarURI = rubygemsWarURL.toString();
        this.cachedir = new File(System.getProperty("user.home"), ".gradle/rubygems");
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setRequestHeaderSize(8192);
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        this.connector.setPort(0);
        this.connector.setHost("localhost");
        this.server.setConnectors(new Connector[]{this.connector});
        this.log.setLevel(3);
        Log.setLog((Logger)this.log);
    }

    public String addRepository(String url) {
        if (this.urls.contains(url)) {
            return null;
        }
        String path = "/" + url.replace("://", "_").replace(":", "_").replace("/", "_").replace(".", "_");
        WebAppContext context = new WebAppContext();
        context.setServer(this.server);
        context.setContextPath(path);
        context.setExtractWAR(false);
        context.setCopyWebInf(true);
        context.setWar(this.rubygemsWarURI);
        context.setInitParameter("gem-caching-proxy-url", url);
        context.setInitParameter("gem-caching-proxy-storage", new File(this.cachedir, path).getAbsolutePath());
        context.setInitParameter("gem-proxy-storage", "");
        context.setInitParameter("gem-hosted-storage", "");
        context.setInitParameter("gem-merged", "false");
        this.handlerCollection.addHandler((Handler)context);
        return path + "/caching/maven/releases";
    }

    public void enableLogging() {
        this.log.setLevel(2);
    }

    public String getURL(String path) {
        return "http://localhost:" + this.connector.getLocalPort() + path;
    }

    public void start() throws Exception {
        this.server.setHandler((Handler)this.handlerCollection);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.join();
    }
}

