/*
 * Decompiled with CFR 0.152.
 */
package com.jp.androidlogger;

import android.util.Log;
import com.jp.androidlogger.AndroidLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class AndroidLoggerFactory
implements ILoggerFactory {
    private static final boolean EXTRA_LOGGING = false;
    private static final String TAG = "AndroidLoggerFactory";
    private static final int TAG_MAX_LENGTH = 23;
    private String tagPrefix;
    private int logLevel = 2;
    private boolean isMultilineLoggingEnabled;
    private int maxCharactersPerLine = 4000;
    private int maxWrapLines = 0;
    private static final String DEFAULT_DATE_FORMAT = "MM-dd HH:mm:ss";
    private File logFile;
    private SimpleDateFormat simpleDateFormat;
    private final ConcurrentHashMap<String, AndroidLogger> nameToLogMap = new ConcurrentHashMap();

    public void setTagPrefix(String prefix) {
        if (prefix == null || prefix.equals(this.tagPrefix)) {
            return;
        }
        this.tagPrefix = prefix;
        for (Map.Entry<String, AndroidLogger> entry : this.nameToLogMap.entrySet()) {
            String name = entry.getKey();
            AndroidLogger logger = entry.getValue();
            String tag = this.getTag(name);
            logger.setName(tag);
        }
    }

    public void setDebugLevel(int level) {
        this.logLevel = level;
    }

    public void setMultilineLoggingEnabled(boolean isEnabled) {
        this.isMultilineLoggingEnabled = isEnabled;
    }

    public void setMaxCharactersPerLine(int maxCharactersPerLine) {
        this.maxCharactersPerLine = maxCharactersPerLine;
    }

    public void setMaxWrapLines(int maxWrapLines) {
        this.maxWrapLines = maxWrapLines;
    }

    public void logToFile(File logFile, boolean append) {
        this.logFile = logFile;
        if (!append) {
            logFile.delete();
        }
    }

    public Logger getLogger(String name) {
        String tag;
        AndroidLogger existingLogger;
        AndroidLogger logger = this.nameToLogMap.get(name);
        if (logger == null && (existingLogger = this.nameToLogMap.putIfAbsent(name, logger = new AndroidLogger(tag = this.getTag(name), this))) != null) {
            logger = existingLogger;
        }
        return logger;
    }

    private String getTag(String name) {
        String prefix;
        if (name == null) {
            Log.w((String)TAG, (String)"getTag: name is NULL!");
            return "";
        }
        String tag = name;
        int indexOfLastDot = name.lastIndexOf(46);
        if (indexOfLastDot > 0 && indexOfLastDot < name.length() - 2 && (tag = (prefix = this.tagPrefix != null ? this.tagPrefix + "_" : "") + name.substring(indexOfLastDot + 1)).length() > 23) {
            tag = tag.substring(0, 23);
        }
        return tag;
    }

    boolean isEnabled(int logLevel) {
        return this.logLevel <= logLevel;
    }

    int getMaxCharactersPerLine() {
        return this.maxCharactersPerLine;
    }

    int getMaxWrapLines() {
        return this.maxWrapLines;
    }

    boolean isLongLoggingEnabled() {
        return this.isMultilineLoggingEnabled;
    }

    void logToFile(int logLevel, String name, String message) {
        char level;
        if (this.logFile == null) {
            return;
        }
        if (this.simpleDateFormat == null) {
            this.simpleDateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.US);
        }
        switch (logLevel) {
            case 3: {
                level = 'D';
                break;
            }
            case 2: {
                level = 'V';
                break;
            }
            case 4: {
                level = 'I';
                break;
            }
            case 6: {
                level = 'E';
                break;
            }
            default: {
                level = Character.forDigit(logLevel, 10);
            }
        }
        try {
            FileWriter logWriter = new FileWriter(this.logFile, true);
            BufferedWriter out = new BufferedWriter(logWriter);
            out.write(this.simpleDateFormat.format(new Date()));
            out.write(" " + level + " " + " " + name + " ");
            out.write(message);
            out.newLine();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

