/*
 * Decompiled with CFR 0.152.
 */
package com.github.jokar.permission;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.PermissionChecker;
import android.support.v4.util.SimpleArrayMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/jokar/permission/Utils;", "", "()V", "Companion", "library_release"})
public final class Utils {
    private static SimpleArrayMap<String, Integer> MIN_SDK_PERMISSIONS;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        MIN_SDK_PERMISSIONS = new SimpleArrayMap(8);
        MIN_SDK_PERMISSIONS.put((Object)"com.android.voicemail.permission.ADD_VOICEMAIL", (Object)14);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.BODY_SENSORS", (Object)20);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_EXTERNAL_STORAGE", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.USE_SIP", (Object)9);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.SYSTEM_ALERT_WINDOW", (Object)23);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_SETTINGS", (Object)23);
    }

    public static final /* synthetic */ void access$setMIN_SDK_PERMISSIONS$cp(SimpleArrayMap simpleArrayMap) {
        MIN_SDK_PERMISSIONS = simpleArrayMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J'\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u00020\b2\n\u0010\u0016\u001a\u00020\u0017\"\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/jokar/permission/Utils$Companion;", "", "()V", "MIN_SDK_PERMISSIONS", "Landroid/support/v4/util/SimpleArrayMap;", "", "", "hasPermissions", "", "context", "Landroid/content/Context;", "permissions", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "hasSelfPermission", "permission", "permissionExists", "shouldShowRequestPermissionRationale", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;[Ljava/lang/String;)Z", "verifyPermissions", "grantResults", "", "library_release"})
    public static final class Companion {
        private final boolean permissionExists(String permission) {
            Integer minVersion = (Integer)MIN_SDK_PERMISSIONS.get((Object)permission);
            return minVersion == null || Intrinsics.compare((int)Build.VERSION.SDK_INT, (int)minVersion) >= 0;
        }

        private final boolean hasSelfPermission(Context context, String permission) {
            boolean bl;
            try {
                bl = PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
            }
            catch (RuntimeException t) {
                bl = false;
            }
            return bl;
        }

        public final boolean hasPermissions(@NotNull Context context, String ... permissions) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            if (Build.VERSION.SDK_INT < 23) {
                return true;
            }
            String[] $this$forEach$iv = permissions;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl = false;
                if (!Companion.permissionExists(it) || Companion.hasSelfPermission(context, it)) continue;
                return false;
            }
            return true;
        }

        public final boolean shouldShowRequestPermissionRationale(@NotNull Activity activity, String ... permissions) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
                String[] $this$all$iv = permissions;
                boolean $i$f$all = false;
                String[] stringArray = $this$all$iv;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = stringArray[i];
                    boolean bl2 = false;
                    if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)it)) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public final boolean verifyPermissions(int ... grantResults) {
            Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
            int[] nArray = grantResults;
            int n = 0;
            if (nArray.length == 0) {
                return false;
            }
            for (int result : grantResults) {
                if (result == 0) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

