/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import com.github.joelittlejohn.embedmongo.AbstractEmbeddedMongoMojo;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="mongo-scripts", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class MongoScriptsMojo
extends AbstractEmbeddedMongoMojo {
    @Parameter(property="scriptsDirectory", required=true)
    private File scriptsDirectory;
    @Parameter(property="scriptCharsetEncoding", required=false)
    private String scriptCharsetEncoding;
    @Parameter(property="databaseName", required=true)
    private String databaseName;

    public MongoScriptsMojo() {
    }

    MongoScriptsMojo(File scriptsDirectory, int port, String databaseName, String scriptCharsetEncoding) {
        super(port);
        this.scriptsDirectory = scriptsDirectory;
        this.databaseName = databaseName;
        this.scriptCharsetEncoding = scriptCharsetEncoding;
    }

    @Override
    public void executeStart() throws MojoExecutionException, MojoFailureException {
        DB db = this.connectToMongoAndGetDatabase();
        if (this.scriptsDirectory.isDirectory()) {
            Scanner scanner = null;
            StringBuilder instructions = new StringBuilder();
            File[] files = this.scriptsDirectory.listFiles();
            if (files == null) {
                this.getLog().info((CharSequence)("Can't read scripts directory: " + this.scriptsDirectory.getAbsolutePath()));
            } else {
                this.getLog().info((CharSequence)("Folder " + this.scriptsDirectory.getAbsolutePath() + " contains " + files.length + " file(s):"));
                for (File file : files) {
                    CommandResult result;
                    if (!file.isFile()) continue;
                    try {
                        scanner = this.scriptCharsetEncoding == null ? new Scanner(file) : new Scanner(file, this.scriptCharsetEncoding);
                        while (scanner.hasNextLine()) {
                            instructions.append(scanner.nextLine()).append("\n");
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new MojoExecutionException("Unable to find file with name '" + file.getName() + "'", (Exception)e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MojoExecutionException("Unable to determine charset encoding for provided charset '" + this.scriptCharsetEncoding + "'", (Exception)e);
                    }
                    finally {
                        if (scanner != null) {
                            scanner.close();
                        }
                    }
                    try {
                        result = db.doEval("(function() {" + instructions.toString() + "})();", new Object[0]);
                    }
                    catch (MongoException e) {
                        throw new MojoExecutionException("Unable to execute file with name '" + file.getName() + "'", (Exception)((Object)e));
                    }
                    if (!result.ok()) {
                        this.getLog().error((CharSequence)("- file " + file.getName() + " parsed with error: " + result.getErrorMessage()));
                        throw new MojoExecutionException("Error while executing instructions from file '" + file.getName() + "': " + result.getErrorMessage(), (Exception)((Object)result.getException()));
                    }
                    this.getLog().info((CharSequence)("- file " + file.getName() + " parsed successfully"));
                }
            }
            this.getLog().info((CharSequence)"Data initialized with success");
        }
    }

    DB connectToMongoAndGetDatabase() throws MojoExecutionException {
        MongoClient mongoClient;
        if (this.databaseName == null || this.databaseName.trim().length() == 0) {
            throw new MojoExecutionException("Database name is missing");
        }
        try {
            mongoClient = new MongoClient("localhost", this.getPort().intValue());
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Unable to connect to mongo instance", (Exception)e);
        }
        this.getLog().info((CharSequence)"Connected to MongoDB");
        return mongoClient.getDB(this.databaseName);
    }
}

