/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import com.github.joelittlejohn.embedmongo.AbstractEmbeddedMongoMojo;
import com.github.joelittlejohn.embedmongo.ImportDataConfig;
import com.github.joelittlejohn.embedmongo.NetworkUtils;
import de.flapdoodle.embed.mongo.MongoImportExecutable;
import de.flapdoodle.embed.mongo.MongoImportProcess;
import de.flapdoodle.embed.mongo.MongoImportStarter;
import de.flapdoodle.embed.mongo.config.IMongoImportConfig;
import de.flapdoodle.embed.mongo.config.MongoImportConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="mongo-import", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class MongoImportMojo
extends AbstractEmbeddedMongoMojo {
    @Parameter
    private ImportDataConfig[] imports;
    @Parameter(property="embedmongo.defaultImportDatabase")
    private String defaultImportDatabase;
    @Parameter(property="embedmongo.parallel", defaultValue="false")
    private Boolean parallel;

    @Override
    public void executeStart() throws MojoExecutionException, MojoFailureException {
        try {
            this.sendImportScript();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void sendImportScript() throws IOException, InterruptedException, MojoExecutionException {
        ArrayList<MongoImportProcess> pendingMongoProcess = new ArrayList<MongoImportProcess>();
        if (this.imports == null || this.imports.length == 0) {
            this.getLog().error((CharSequence)"No imports found, check your configuration");
            return;
        }
        this.getLog().info((CharSequence)("Default import database: " + this.defaultImportDatabase));
        for (ImportDataConfig importData : this.imports) {
            this.getLog().info((CharSequence)("Import " + importData));
            this.verify(importData);
            String database = importData.getDatabase();
            if (StringUtils.isBlank((CharSequence)database)) {
                database = this.defaultImportDatabase;
            }
            IMongoImportConfig mongoImportConfig = new MongoImportConfigBuilder().version(this.getVersion()).net(new Net(this.getPort().intValue(), NetworkUtils.localhostIsIPv6())).db(database).collection(importData.getCollection()).upsert(importData.getUpsertOnImport().booleanValue()).dropCollection(importData.getDropOnImport().booleanValue()).importFile(importData.getFile()).jsonArray(true).timeout(new Timeout(importData.getTimeout())).build();
            MongoImportExecutable mongoImport = (MongoImportExecutable)MongoImportStarter.getDefaultInstance().prepare((IExecutableProcessConfig)mongoImportConfig);
            MongoImportProcess importProcess = (MongoImportProcess)mongoImport.start();
            if (this.parallel.booleanValue()) {
                pendingMongoProcess.add(importProcess);
                continue;
            }
            this.waitFor(importProcess);
        }
        for (MongoImportProcess importProcess : pendingMongoProcess) {
            this.waitFor(importProcess);
        }
    }

    private void waitFor(MongoImportProcess importProcess) throws InterruptedException, MojoExecutionException {
        int code = importProcess.waitFor();
        if (code != 0) {
            throw new MojoExecutionException("Cannot import '" + ((IMongoImportConfig)importProcess.getConfig()).getImportFile() + "'");
        }
        this.getLog().info((CharSequence)("Import return code: " + code));
    }

    private void verify(ImportDataConfig config) {
        Validate.notBlank((CharSequence)config.getFile(), (String)"Import file is required\n\n<imports>\n\t<import>\n\t\t<file>[my file]</file>\n...", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)this.defaultImportDatabase) || StringUtils.isNotBlank((CharSequence)config.getDatabase()) ? 1 : 0) != 0, (String)"Database is required you can either define a defaultImportDatabase or a <database> on import tags", (Object[])new Object[0]);
    }
}

