/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.changelog;

import git.semver.plugin.changelog.ChangeLogBuilder;
import git.semver.plugin.changelog.ChangeLogTexts;
import git.semver.plugin.scm.Commit;
import git.semver.plugin.semver.SemverSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0003()*B\u001e\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J<\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001a\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J$\u0010\u0017\u001a\u00020\u00002\u0019\b\u0002\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J$\u0010\u001a\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cJ.\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0012H\u00d6\u0001J\u0016\u0010%\u001a\u0004\u0018\u00010\u0012*\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0002R\"\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lgit/semver/plugin/changelog/ChangeLogFormatter;", "", "builder", "Lkotlin/Function1;", "Lgit/semver/plugin/changelog/ChangeLogBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "getBuilder", "()Lkotlin/jvm/functions/Function1;", "commitInfos", "", "Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;", "changeLog", "Lgit/semver/plugin/scm/Commit;", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "pattern", "", "sorByText", "", "groupByText", "component1", "copy", "equals", "other", "formatLog", "changeLogTexts", "Lgit/semver/plugin/changelog/ChangeLogTexts;", "getCommitInfo", "changeLogRegex", "Lkotlin/text/Regex;", "text", "commits", "hashCode", "", "toString", "groupValue", "Lkotlin/text/MatchResult;", "groupId", "CommitInfo", "Companion", "Context", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nChangeLogFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogFormatter.kt\ngit/semver/plugin/changelog/ChangeLogFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,87:1\n1053#2:88\n1485#2:89\n1510#2,3:90\n1513#2,3:100\n1557#2:107\n1628#2,3:108\n381#3,7:93\n126#4:103\n153#4,3:104\n*S KotlinDebug\n*F\n+ 1 ChangeLogFormatter.kt\ngit/semver/plugin/changelog/ChangeLogFormatter\n*L\n37#1:88\n40#1:89\n40#1:90,3\n40#1:100,3\n42#1:107\n42#1:108,3\n40#1:93,7\n40#1:103\n40#1:104,3\n*E\n"})
public final class ChangeLogFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ChangeLogBuilder, Unit> builder;
    @NotNull
    private static final String SCOPE = "Scope";
    @NotNull
    private static final String TYPE = "Type";
    @NotNull
    private static final String MESSAGE = "Message";

    public ChangeLogFormatter(@NotNull Function1<? super ChangeLogBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.builder = builder;
    }

    @NotNull
    public final Function1<ChangeLogBuilder, Unit> getBuilder() {
        return this.builder;
    }

    @NotNull
    public final String formatLog(@NotNull List<Commit> changeLog, @NotNull SemverSettings settings, @NotNull ChangeLogTexts changeLogTexts) {
        Intrinsics.checkNotNullParameter(changeLog, (String)"changeLog");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)changeLogTexts, (String)"changeLogTexts");
        List<CommitInfo> commitInfos = this.commitInfos(changeLog, settings, changeLogTexts.getChangeLogPattern(), changeLogTexts.getSortByText(), changeLogTexts.getGroupByText());
        ChangeLogBuilder changeLogBuilder = new ChangeLogBuilder("#", commitInfos, new Context(), changeLogTexts);
        this.builder.invoke((Object)changeLogBuilder);
        return changeLogBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommitInfo> commitInfos(List<Commit> changeLog, SemverSettings settings, String pattern, boolean sorByText, boolean groupByText) {
        List list;
        List logEntries;
        Regex changeLogRegex = new Regex(pattern, SemverSettings.Companion.getREGEX_OPTIONS());
        if (sorByText) {
            Iterable $this$sortedBy$iv = changeLog;
            boolean $i$f$sortedBy = false;
            v0 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Commit it = (Commit)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getText());
                    it = (Commit)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getText())));
                }
            });
        } else {
            v0 = logEntries = changeLog;
        }
        if (groupByText) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            boolean bl;
            Commit it;
            Iterable $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = logEntries;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object;
                it = (Commit)t;
                bl = false;
                String key$iv$iv = it.getText();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv;
            $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                Object object = destination$iv$iv;
                bl = false;
                object.add(this.getCommitInfo(settings, changeLogRegex, (String)it.getKey(), (List)it.getValue()));
            }
            list = (List)destination$iv$iv;
        } else {
            $this$map$iv = logEntries;
            $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                Commit it = (Commit)t;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getCommitInfo(settings, changeLogRegex, it.getText(), CollectionsKt.listOf((Object)it)));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final CommitInfo getCommitInfo(SemverSettings settings, Regex changeLogRegex, String text, List<Commit> commits2) {
        CommitInfo commitInfo;
        boolean isBreakingChange = settings.getMajorRegex$git_semver_plugin().containsMatchIn((CharSequence)text);
        MatchResult matchResult = Regex.find$default((Regex)changeLogRegex, (CharSequence)text, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            commitInfo = new CommitInfo(commits2, text, isBreakingChange, this.groupValue(it, TYPE), this.groupValue(it, SCOPE), this.groupValue(it, MESSAGE));
        } else {
            commitInfo = new CommitInfo(commits2, text, isBreakingChange, null, null, null, 56, null);
        }
        return commitInfo;
    }

    private final String groupValue(MatchResult $this$groupValue, String groupId) {
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$groupValue.getGroups(), (String)groupId);
        return matchGroup != null ? matchGroup.getValue() : null;
    }

    @NotNull
    public final Function1<ChangeLogBuilder, Unit> component1() {
        return this.builder;
    }

    @NotNull
    public final ChangeLogFormatter copy(@NotNull Function1<? super ChangeLogBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return new ChangeLogFormatter(builder);
    }

    public static /* synthetic */ ChangeLogFormatter copy$default(ChangeLogFormatter changeLogFormatter, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = changeLogFormatter.builder;
        }
        return changeLogFormatter.copy(function1);
    }

    @NotNull
    public String toString() {
        return "ChangeLogFormatter(builder=" + this.builder + ")";
    }

    public int hashCode() {
        return this.builder.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChangeLogFormatter)) {
            return false;
        }
        ChangeLogFormatter changeLogFormatter = (ChangeLogFormatter)other;
        return Intrinsics.areEqual(this.builder, changeLogFormatter.builder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003JQ\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006!"}, d2={"Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;", "", "commits", "", "Lgit/semver/plugin/scm/Commit;", "text", "", "isBreaking", "", "type", "scope", "message", "(Ljava/util/List;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCommits", "()Ljava/util/List;", "()Z", "getMessage", "()Ljava/lang/String;", "getScope", "getText", "getType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "git-semver-plugin"})
    public static final class CommitInfo {
        @NotNull
        private final List<Commit> commits;
        @NotNull
        private final String text;
        private final boolean isBreaking;
        @Nullable
        private final String type;
        @Nullable
        private final String scope;
        @Nullable
        private final String message;

        public CommitInfo(@NotNull List<Commit> commits2, @NotNull String text, boolean isBreaking, @Nullable String type, @Nullable String scope, @Nullable String message) {
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.commits = commits2;
            this.text = text;
            this.isBreaking = isBreaking;
            this.type = type;
            this.scope = scope;
            this.message = message;
        }

        public /* synthetic */ CommitInfo(List list, String string, boolean bl, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                string4 = null;
            }
            this(list, string, bl, string2, string3, string4);
        }

        @NotNull
        public final List<Commit> getCommits() {
            return this.commits;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean isBreaking() {
            return this.isBreaking;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getScope() {
            return this.scope;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final List<Commit> component1() {
            return this.commits;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        public final boolean component3() {
            return this.isBreaking;
        }

        @Nullable
        public final String component4() {
            return this.type;
        }

        @Nullable
        public final String component5() {
            return this.scope;
        }

        @Nullable
        public final String component6() {
            return this.message;
        }

        @NotNull
        public final CommitInfo copy(@NotNull List<Commit> commits2, @NotNull String text, boolean isBreaking, @Nullable String type, @Nullable String scope, @Nullable String message) {
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new CommitInfo(commits2, text, isBreaking, type, scope, message);
        }

        public static /* synthetic */ CommitInfo copy$default(CommitInfo commitInfo, List list, String string, boolean bl, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                list = commitInfo.commits;
            }
            if ((n & 2) != 0) {
                string = commitInfo.text;
            }
            if ((n & 4) != 0) {
                bl = commitInfo.isBreaking;
            }
            if ((n & 8) != 0) {
                string2 = commitInfo.type;
            }
            if ((n & 0x10) != 0) {
                string3 = commitInfo.scope;
            }
            if ((n & 0x20) != 0) {
                string4 = commitInfo.message;
            }
            return commitInfo.copy(list, string, bl, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "CommitInfo(commits=" + this.commits + ", text=" + this.text + ", isBreaking=" + this.isBreaking + ", type=" + this.type + ", scope=" + this.scope + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = ((Object)this.commits).hashCode();
            result = result * 31 + this.text.hashCode();
            int n = this.isBreaking ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitInfo)) {
                return false;
            }
            CommitInfo commitInfo = (CommitInfo)other;
            if (!Intrinsics.areEqual(this.commits, commitInfo.commits)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)commitInfo.text)) {
                return false;
            }
            if (this.isBreaking != commitInfo.isBreaking) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)commitInfo.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)commitInfo.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)commitInfo.message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit/semver/plugin/changelog/ChangeLogFormatter$Companion;", "", "()V", "MESSAGE", "", "SCOPE", "TYPE", "git-semver-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit/semver/plugin/changelog/ChangeLogFormatter$Context;", "", "()V", "flaggedCommits", "", "Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;", "flagCommit", "", "commit", "isCommitFlagged", "", "git-semver-plugin"})
    public static final class Context {
        @NotNull
        private final Set<CommitInfo> flaggedCommits = new LinkedHashSet();

        public final void flagCommit(@NotNull CommitInfo commit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            this.flaggedCommits.add(commit);
        }

        public final boolean isCommitFlagged(@NotNull CommitInfo commit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            return this.flaggedCommits.contains(commit);
        }
    }
}

