/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.core;

import android.app.Application;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.luojilab.component.componentlib.log.ILogger;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.github.jimu.msg.AriseAt;
import org.github.jimu.msg.ConsumeOn;
import org.github.jimu.msg.EventListener;
import org.github.jimu.msg.bean.EventBean;
import org.github.jimu.msg.bean.RemoteEventBean;
import org.github.jimu.msg.bean.State;
import org.github.jimu.msg.core.MessageBridgeAttacher;
import org.github.jimu.msg.core.MessageBridgeService;
import org.github.jimu.msg.core.SubscriberCache;
import org.github.jimu.msg.core.SubscriberList;
import org.github.jimu.msg.executor.IPoster;

public final class Secy {
    private final IPoster mainThreadPoster;
    private final IPoster workThreadPoster;
    private final IPoster crossProcessPoster;
    private final SubscriberCache mainThreadSubscriber = new SubscriberCache();
    private final SubscriberCache workThreadSubscriber = new SubscriberCache();
    private final Map<String, Class<? extends MessageBridgeService>> processMsgBridgeServiceMapper;
    private final Map<String, MessageBridgeAttacher> remoteBridgeAttachers = new HashMap<String, MessageBridgeAttacher>();
    private Application application;

    public Secy(Application application, IPoster mainThreadPoster, IPoster workThreadPoster, IPoster crossProcessPoster, Map<String, Class<? extends MessageBridgeService>> processMsgBridgeServiceMapper) {
        this.application = application;
        this.mainThreadPoster = mainThreadPoster;
        this.workThreadPoster = workThreadPoster;
        this.crossProcessPoster = crossProcessPoster;
        this.processMsgBridgeServiceMapper = processMsgBridgeServiceMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventBean> void subscribe(@NonNull Class<T> eventClz, @NonNull AriseAt ariseAt, @NonNull ConsumeOn consumeOn, @NonNull EventListener<T> listener) {
        Class<Secy> clazz = Secy.class;
        synchronized (Secy.class) {
            if (!ariseAt.isLocal()) {
                MessageBridgeAttacher attacher;
                String processFullName = ariseAt.getProcessFullName();
                if (this.remoteBridgeAttachers.containsKey(processFullName)) {
                    attacher = this.remoteBridgeAttachers.get(processFullName);
                } else {
                    attacher = this.createAttacher(processFullName);
                    this.remoteBridgeAttachers.put(processFullName, attacher);
                }
                try {
                    attacher.onSubscribe(eventClz);
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    ILogger.logger.error("[DD-Compo]", e.getMessage());
                }
            }
            this.subscribeEvent(eventClz, consumeOn, listener);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @NonNull
    private synchronized MessageBridgeAttacher createAttacher(String processName) {
        if (TextUtils.isEmpty((CharSequence)processName)) {
            ILogger.logger.error("[DD-Compo]", "cannot execute for a empty process name");
            throw new IllegalArgumentException("processName cannot be empty");
        }
        Class<? extends MessageBridgeService> bridgeServiceClz = null;
        if (!this.processMsgBridgeServiceMapper.containsKey(processName)) {
            String errorMsg = "cannot find target bridge service for" + processName + " are you missing decline it?";
            ILogger.logger.error("[DD-Compo]", errorMsg);
            throw new RuntimeException(errorMsg);
        }
        bridgeServiceClz = this.processMsgBridgeServiceMapper.get(processName);
        MessageBridgeAttacher attacher = new MessageBridgeAttacher(processName, bridgeServiceClz, this.application);
        return attacher;
    }

    private <T extends EventBean> void subscribeEvent(@NonNull Class<T> eventClz, @NonNull ConsumeOn consumeOn, @NonNull EventListener<T> listener) {
        SubscriberCache cache = ConsumeOn.Main.equals((Object)consumeOn) ? this.mainThreadSubscriber : this.workThreadSubscriber;
        SubscriberList<EventBean> subscribers = cache.get(eventClz);
        if (subscribers == null) {
            subscribers = new SubscriberList<EventBean>();
            cache.put(eventClz, subscribers);
        }
        WeakReference<EventListener<T>> listenerRef = new WeakReference<EventListener<T>>(listener);
        subscribers.add(listenerRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventBean> void postNormalEventOnLocalProcess(State threadLocalState, T event) {
        threadLocalState.addEvent2Queue(event);
        if (!threadLocalState.onPosting) {
            threadLocalState.onPosting = true;
            try {
                while (!threadLocalState.isQueueEmpty()) {
                    Object temp = threadLocalState.peekFromQueue();
                    Class<?> clz = event.getClass();
                    this.postOneOnLocalProcess(temp, threadLocalState, clz);
                }
            }
            finally {
                threadLocalState.onPosting = false;
            }
        } else {
            ILogger.logger.error("[DD-Compo]", "bug!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RemoteEventBean> void postNormalEventToRemoteProcess(State threadLocalState, T event) {
        threadLocalState.addEvent2Queue(event);
        if (!threadLocalState.onPosting) {
            threadLocalState.onPosting = true;
            ILogger.logger.monitor("on post remote:");
            try {
                while (!threadLocalState.isQueueEmpty()) {
                    RemoteEventBean temp = (RemoteEventBean)threadLocalState.peekFromQueue();
                    Class<?> clz = event.getClass();
                    ILogger.logger.monitor("post remote:" + clz.getName());
                    this.postOne2RemoteProcess(temp);
                }
                ILogger.logger.monitor("all remote posted");
            }
            finally {
                threadLocalState.onPosting = false;
            }
        } else {
            ILogger.logger.error("[DD-Compo]", "bug!");
        }
    }

    private <T extends RemoteEventBean> void postOne2RemoteProcess(T event) {
        this.crossProcessPoster.postEvent(event, EventListener.NONE_NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends EventBean> void postOneOnLocalProcess(T event, State state, Class<T> eventClass) {
        WeakReference subscriberRef;
        Object workThreadSubscribers;
        Object mainThreadSubscribers;
        Iterator iterator = this;
        synchronized (iterator) {
            mainThreadSubscribers = this.mainThreadSubscriber.get(eventClass);
            workThreadSubscribers = this.workThreadSubscriber.get(eventClass);
        }
        if (mainThreadSubscribers != null && !((CopyOnWriteArrayList)mainThreadSubscribers).isEmpty()) {
            iterator = ((CopyOnWriteArrayList)mainThreadSubscribers).iterator();
            while (iterator.hasNext()) {
                subscriberRef = (WeakReference)iterator.next();
                if (subscriberRef.get() == null) continue;
                try {
                    if (state.onMainThread) {
                        ((EventListener)subscriberRef.get()).onEvent(event);
                        continue;
                    }
                    this.mainThreadPoster.postEvent(event, (EventListener)subscriberRef.get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (workThreadSubscribers != null && !((CopyOnWriteArrayList)workThreadSubscribers).isEmpty()) {
            iterator = ((CopyOnWriteArrayList)workThreadSubscribers).iterator();
            while (iterator.hasNext()) {
                subscriberRef = (WeakReference)iterator.next();
                if (subscriberRef.get() == null) continue;
                try {
                    this.workThreadPoster.postEvent(event, (EventListener)subscriberRef.get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public <T extends EventBean> void unsubscribe(@NonNull EventListener<T> listener) {
        this.removeSubscribe(this.mainThreadSubscriber, listener);
        this.removeSubscribe(this.workThreadSubscriber, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscribe(SubscriberCache cache, EventListener listener) {
        Class<Secy> clazz = Secy.class;
        synchronized (Secy.class) {
            Set keys = cache.keySet();
            for (Class clz : keys) {
                boolean b;
                Object list = cache.get(clz);
                if (list == null || !(b = ((SubscriberList)list).removeCallback(listener))) continue;
                ILogger.logger.monitor("remove one subscribe success");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

