/*
 * Decompiled with CFR 0.152.
 */
package org.github.jimu.msg.core;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.luojilab.component.componentlib.log.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.github.jimu.msg.bean.RemoteEventBean;
import org.github.jimu.msg.core.CrossSubscriberHandler;
import org.github.jimu.msg.core.MessageFactory;

final class MessageBridgeAttacher {
    private String remoteProcessName;
    private Class<?> msgBridgeServiceClz;
    private Application application;
    @Nullable
    private Messenger remoteMessenger;
    private Messenger localMessenger = new Messenger((Handler)new CrossSubscriberHandler());
    private boolean hasAttached = false;
    private List<Class> subscribeCache = new ArrayList<Class>();
    private final List<Class> trash = new ArrayList<Class>();

    MessageBridgeAttacher(String remoteProcessName, Class<?> msgBridgeServiceClz, Application application) {
        this.remoteProcessName = remoteProcessName;
        this.msgBridgeServiceClz = msgBridgeServiceClz;
        this.application = application;
        this.onCreate();
    }

    private void onCreate() {
        Intent intent = new Intent((Context)this.application, this.msgBridgeServiceClz);
        PackageManager packageManager = this.application.getPackageManager();
        List targets = packageManager.queryIntentServices(intent, 65536);
        if (targets == null || targets.isEmpty()) {
            ILogger.logger.error("[DD-Compo]", "cannot attach remote message bridge for process:" + this.remoteProcessName);
            return;
        }
        this.application.bindService(intent, new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                MessageBridgeAttacher messageBridgeAttacher = MessageBridgeAttacher.this;
                synchronized (messageBridgeAttacher) {
                    MessageBridgeAttacher.this.remoteMessenger = new Messenger(service);
                    MessageBridgeAttacher.this.hasAttached = true;
                    MessageBridgeAttacher.this.subscribe2Remote();
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        }, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Class<? extends RemoteEventBean> clz) {
        MessageBridgeAttacher messageBridgeAttacher = this;
        synchronized (messageBridgeAttacher) {
            if (this.trash.contains(clz)) {
                ILogger.logger.monitor("has attach messenger to remote " + this.remoteProcessName + " for:" + clz.getName());
                return;
            }
            this.subscribeCache.add(clz);
            this.subscribe2Remote();
        }
    }

    private void subscribe2Remote() {
        if (!this.hasAttached) {
            return;
        }
        while (!this.subscribeCache.isEmpty()) {
            Class clz = this.subscribeCache.remove(0);
            try {
                this.remoteMessenger.send(MessageFactory.obtainSubscribeMsg(this.localMessenger, clz));
                this.trash.add(clz);
            }
            catch (RemoteException | NullPointerException e) {
                e.printStackTrace();
            }
        }
    }
}

