/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs.optional.ccm;

import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.Execute;
import shadow.org.apache.tools.ant.taskdefs.optional.ccm.Continuus;
import shadow.org.apache.tools.ant.types.Commandline;

public class CCMReconfigure
extends Continuus {
    private String ccmProject = null;
    private boolean recurse = false;
    private boolean verbose = false;
    public static final String FLAG_RECURSE = "/recurse";
    public static final String FLAG_VERBOSE = "/verbose";
    public static final String FLAG_PROJECT = "/project";

    public CCMReconfigure() {
        this.setCcmAction("reconfigure");
    }

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        commandLine.setExecutable(this.getCcmCommand());
        commandLine.createArgument().setValue(this.getCcmAction());
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (Execute.isFailure(result)) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.getLocation());
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.isRecurse()) {
            cmd.createArgument().setValue(FLAG_RECURSE);
        }
        if (this.isVerbose()) {
            cmd.createArgument().setValue(FLAG_VERBOSE);
        }
        if (this.getCcmProject() != null) {
            cmd.createArgument().setValue(FLAG_PROJECT);
            cmd.createArgument().setValue(this.getCcmProject());
        }
    }

    public String getCcmProject() {
        return this.ccmProject;
    }

    public void setCcmProject(String v) {
        this.ccmProject = v;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean v) {
        this.recurse = v;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }
}

