/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import shadow.org.apache.logging.log4j.message.AsynchronouslyFormattable;
import shadow.org.apache.logging.log4j.message.ParameterFormatter;
import shadow.org.apache.logging.log4j.util.BiConsumer;
import shadow.org.apache.logging.log4j.util.EnglishEnums;
import shadow.org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import shadow.org.apache.logging.log4j.util.IndexedStringMap;
import shadow.org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import shadow.org.apache.logging.log4j.util.PerformanceSensitive;
import shadow.org.apache.logging.log4j.util.SortedArrayStringMap;
import shadow.org.apache.logging.log4j.util.StringBuilders;
import shadow.org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiFormatStringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(int initialCapacity) {
        this.data = new SortedArrayStringMap(initialCapacity);
    }

    public MapMessage(Map<String, V> map) {
        this.data = new SortedArrayStringMap(map);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] result = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            result[i] = this.data.getValueAt(i);
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, V> getData() {
        TreeMap result = new TreeMap();
        for (int i = 0; i < this.data.size(); ++i) {
            result.put(this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        return Collections.unmodifiableMap(result);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    public void put(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("No value provided for key " + key);
        }
        this.validate(key, value);
        this.data.putValue(key, value);
    }

    public void putAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.data.putValue(entry.getKey(), entry.getValue());
        }
    }

    public String get(String key) {
        Object result = this.data.getValue(key);
        return ParameterFormatter.deepToString(result);
    }

    public String remove(String key) {
        String result = this.get(key);
        this.data.remove(key);
        return result;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String format) {
        try {
            return this.format(EnglishEnums.valueOf(MapFormat.class, format), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException ex) {
            return this.asString();
        }
    }

    public <CV> void forEach(BiConsumer<String, ? super CV> action) {
        this.data.forEach(action);
    }

    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> action, S state) {
        this.data.forEach(action, state);
    }

    private StringBuilder format(MapFormat format, StringBuilder sb) {
        if (format == null) {
            this.appendMap(sb);
        } else {
            switch (format) {
                case XML: {
                    this.asXml(sb);
                    break;
                }
                case JSON: {
                    this.asJson(sb);
                    break;
                }
                case JAVA: {
                    this.asJava(sb);
                    break;
                }
                default: {
                    this.appendMap(sb);
                }
            }
        }
        return sb;
    }

    public void asXml(StringBuilder sb) {
        sb.append("<Map>\n");
        for (int i = 0; i < this.data.size(); ++i) {
            sb.append("  <Entry key=\"").append(this.data.getKeyAt(i)).append("\">");
            int size = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            StringBuilders.escapeXml(sb, size);
            sb.append("</Entry>\n");
        }
        sb.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        return this.format(this.getFormat(formats), new StringBuilder()).toString();
    }

    private MapFormat getFormat(String[] formats) {
        if (formats == null || formats.length == 0) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i]);
            if (mapFormat == null) continue;
            return mapFormat;
        }
        return null;
    }

    protected void appendMap(StringBuilder sb) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            sb.append('\"');
        }
    }

    protected void asJson(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"');
            int start = sb.length();
            sb.append(this.data.getKeyAt(i));
            StringBuilders.escapeJson(sb, start);
            sb.append('\"').append(':').append('\"');
            start = sb.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            StringBuilders.escapeJson(sb, start);
            sb.append('\"');
        }
        sb.append('}');
    }

    protected void asJava(StringBuilder sb) {
        sb.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), sb, null);
            sb.append('\"');
        }
        sb.append('}');
    }

    public M newInstance(Map<String, V> map) {
        return (M)new MapMessage<M, V>(map);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.format(null, buffer);
    }

    @Override
    public void formatTo(String[] formats, StringBuilder buffer) {
        this.format(this.getFormat(formats), buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMessage that = (MapMessage)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String key, boolean value) {
    }

    protected void validate(String key, byte value) {
    }

    protected void validate(String key, char value) {
    }

    protected void validate(String key, double value) {
    }

    protected void validate(String key, float value) {
    }

    protected void validate(String key, int value) {
    }

    protected void validate(String key, long value) {
    }

    protected void validate(String key, Object value) {
    }

    protected void validate(String key, short value) {
    }

    protected void validate(String key, String value) {
    }

    public M with(String key, boolean value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, byte value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, char value) {
        this.validate(key, value);
        this.data.putValue(key, Character.valueOf(value));
        return (M)this;
    }

    public M with(String key, double value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, float value) {
        this.validate(key, value);
        this.data.putValue(key, Float.valueOf(value));
        return (M)this;
    }

    public M with(String key, int value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, long value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, Object value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, short value) {
        this.validate(key, value);
        this.data.putValue(key, value);
        return (M)this;
    }

    public M with(String key, String value) {
        this.put(key, value);
        return (M)this;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA;


        public static MapFormat lookupIgnoreCase(String format) {
            return XML.name().equalsIgnoreCase(format) ? XML : (JSON.name().equalsIgnoreCase(format) ? JSON : (JAVA.name().equalsIgnoreCase(format) ? JAVA : null));
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name()};
        }
    }
}

