/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.ManifestException;
import shadow.org.apache.tools.ant.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest {
    public static final String ATTRIBUTE_MANIFEST_VERSION = "Manifest-Version";
    public static final String ATTRIBUTE_SIGNATURE_VERSION = "Signature-Version";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_FROM = "From";
    public static final String ATTRIBUTE_CLASSPATH = "Class-Path";
    public static final String DEFAULT_MANIFEST_VERSION = "1.0";
    public static final int MAX_LINE_LENGTH = 72;
    public static final int MAX_SECTION_LENGTH = 70;
    public static final String EOL = "\r\n";
    public static final String ERROR_FROM_FORBIDDEN = "Manifest attributes should not start with \"From\" in \"";
    public static final String JAR_ENCODING = "UTF-8";
    private static final String ATTRIBUTE_MANIFEST_VERSION_LC = "Manifest-Version".toLowerCase(Locale.ENGLISH);
    private static final String ATTRIBUTE_NAME_LC = "Name".toLowerCase(Locale.ENGLISH);
    private static final String ATTRIBUTE_FROM_LC = "From".toLowerCase(Locale.ENGLISH);
    private static final String ATTRIBUTE_CLASSPATH_LC = "Class-Path".toLowerCase(Locale.ENGLISH);
    private String manifestVersion = "1.0";
    private Section mainSection = new Section();
    private Map<String, Section> sections = new LinkedHashMap<String, Section>();

    /*
     * Exception decompiling
     */
    public static Manifest getDefaultManifest() throws BuildException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Manifest() {
        this.manifestVersion = null;
    }

    public Manifest(Reader r) throws ManifestException, IOException {
        BufferedReader reader = new BufferedReader(r);
        String nextSectionName = this.mainSection.read(reader);
        String readManifestVersion = this.mainSection.getAttributeValue(ATTRIBUTE_MANIFEST_VERSION);
        if (readManifestVersion != null) {
            this.manifestVersion = readManifestVersion;
            this.mainSection.removeAttribute(ATTRIBUTE_MANIFEST_VERSION);
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            Section section = new Section();
            if (nextSectionName == null) {
                Attribute sectionName = new Attribute(line);
                if (!sectionName.getName().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                    throw new ManifestException("Manifest sections should start with a \"Name\" attribute and not \"" + sectionName.getName() + "\"");
                }
                nextSectionName = sectionName.getValue();
            } else {
                Attribute firstAttribute = new Attribute(line);
                section.addAttributeAndCheck(firstAttribute);
            }
            section.setName(nextSectionName);
            nextSectionName = section.read(reader);
            this.addConfiguredSection(section);
        }
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        String sectionName = section.getName();
        if (sectionName == null) {
            throw new BuildException("Sections must have a name");
        }
        this.sections.put(sectionName, section);
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        if (attribute.getKey() == null || attribute.getValue() == null) {
            throw new BuildException("Attributes must have name and value");
        }
        if (attribute.getKey().equals(ATTRIBUTE_MANIFEST_VERSION_LC)) {
            this.manifestVersion = attribute.getValue();
        } else {
            this.mainSection.addConfiguredAttribute(attribute);
        }
    }

    public void merge(Manifest other) throws ManifestException {
        this.merge(other, false);
    }

    public void merge(Manifest other, boolean overwriteMain) throws ManifestException {
        this.merge(other, overwriteMain, false);
    }

    public void merge(Manifest other, boolean overwriteMain, boolean mergeClassPaths) throws ManifestException {
        if (other != null) {
            if (overwriteMain) {
                this.mainSection = (Section)other.mainSection.clone();
            } else {
                this.mainSection.merge(other.mainSection, mergeClassPaths);
            }
            if (other.manifestVersion != null) {
                this.manifestVersion = other.manifestVersion;
            }
            Enumeration<String> e = other.getSectionNames();
            while (e.hasMoreElements()) {
                String sectionName = e.nextElement();
                Section ourSection = this.sections.get(sectionName);
                Section otherSection = other.sections.get(sectionName);
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    this.addConfiguredSection((Section)otherSection.clone());
                    continue;
                }
                ourSection.merge(otherSection, mergeClassPaths);
            }
        }
    }

    public void write(PrintWriter writer) throws IOException {
        this.write(writer, false);
    }

    public void write(PrintWriter writer, boolean flatten) throws IOException {
        writer.print("Manifest-Version: " + this.manifestVersion + EOL);
        String signatureVersion = this.mainSection.getAttributeValue(ATTRIBUTE_SIGNATURE_VERSION);
        if (signatureVersion != null) {
            writer.print("Signature-Version: " + signatureVersion + EOL);
            this.mainSection.removeAttribute(ATTRIBUTE_SIGNATURE_VERSION);
        }
        this.mainSection.write(writer, flatten);
        if (signatureVersion != null) {
            try {
                Attribute svAttr = new Attribute(ATTRIBUTE_SIGNATURE_VERSION, signatureVersion);
                this.mainSection.addConfiguredAttribute(svAttr);
            }
            catch (ManifestException svAttr) {
                // empty catch block
            }
        }
        for (String sectionName : this.sections.keySet()) {
            Section section = this.getSection(sectionName);
            section.write(writer, flatten);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(new PrintWriter(sw));
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    public Enumeration<String> getWarnings() {
        Vector<String> warnings = new Vector<String>();
        Enumeration<String> warnEnum = this.mainSection.getWarnings();
        while (warnEnum.hasMoreElements()) {
            warnings.addElement(warnEnum.nextElement());
        }
        for (Section section : this.sections.values()) {
            Enumeration<String> e2 = section.getWarnings();
            while (e2.hasMoreElements()) {
                warnings.addElement(e2.nextElement());
            }
        }
        return warnings.elements();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.manifestVersion != null) {
            hashCode += this.manifestVersion.hashCode();
        }
        hashCode += this.mainSection.hashCode();
        return hashCode += this.sections.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        Manifest rhsManifest = (Manifest)rhs;
        if (this.manifestVersion == null ? rhsManifest.manifestVersion != null : !this.manifestVersion.equals(rhsManifest.manifestVersion)) {
            return false;
        }
        if (!this.mainSection.equals(rhsManifest.mainSection)) {
            return false;
        }
        return this.sections.equals(rhsManifest.sections);
    }

    public String getManifestVersion() {
        return this.manifestVersion;
    }

    public Section getMainSection() {
        return this.mainSection;
    }

    public Section getSection(String name) {
        return this.sections.get(name);
    }

    public Enumeration<String> getSectionNames() {
        return CollectionUtils.asEnumeration(this.sections.keySet().iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Section {
        private Vector<String> warnings = new Vector();
        private String name = null;
        private Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String read(BufferedReader reader) throws ManifestException, IOException {
            String nameReadAhead;
            Attribute attribute = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null || line.length() == 0) {
                    return null;
                }
                if (line.charAt(0) == ' ') {
                    if (attribute == null) {
                        if (this.name != null) {
                            this.name = this.name + line.substring(1);
                            continue;
                        }
                        throw new ManifestException("Can't start an attribute with a continuation line " + line);
                    }
                    attribute.addContinuation(line);
                    continue;
                }
                attribute = new Attribute(line);
                nameReadAhead = this.addAttributeAndCheck(attribute);
                attribute = this.getAttribute(attribute.getKey());
                if (nameReadAhead != null) break;
            }
            return nameReadAhead;
        }

        public void merge(Section section) throws ManifestException {
            this.merge(section, false);
        }

        public void merge(Section section, boolean mergeClassPaths) throws ManifestException {
            if (this.name == null && section.getName() != null || this.name != null && section.getName() != null && !this.name.toLowerCase(Locale.ENGLISH).equals(section.getName().toLowerCase(Locale.ENGLISH))) {
                throw new ManifestException("Unable to merge sections with different names");
            }
            Enumeration<String> e = section.getAttributeKeys();
            Attribute classpathAttribute = null;
            while (e.hasMoreElements()) {
                String attributeName = e.nextElement();
                Attribute attribute = section.getAttribute(attributeName);
                if (attributeName.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    if (classpathAttribute == null) {
                        classpathAttribute = new Attribute();
                        classpathAttribute.setName(Manifest.ATTRIBUTE_CLASSPATH);
                    }
                    Enumeration<String> cpe = attribute.getValues();
                    while (cpe.hasMoreElements()) {
                        String value = cpe.nextElement();
                        classpathAttribute.addValue(value);
                    }
                    continue;
                }
                this.storeAttribute(attribute);
            }
            if (classpathAttribute != null) {
                Attribute currentCp;
                if (mergeClassPaths && (currentCp = this.getAttribute(Manifest.ATTRIBUTE_CLASSPATH)) != null) {
                    Enumeration<String> attribEnum = currentCp.getValues();
                    while (attribEnum.hasMoreElements()) {
                        String value = attribEnum.nextElement();
                        classpathAttribute.addValue(value);
                    }
                }
                this.storeAttribute(classpathAttribute);
            }
            Enumeration<String> warnEnum = section.warnings.elements();
            while (warnEnum.hasMoreElements()) {
                this.warnings.addElement(warnEnum.nextElement());
            }
        }

        public void write(PrintWriter writer) throws IOException {
            this.write(writer, false);
        }

        public void write(PrintWriter writer, boolean flatten) throws IOException {
            if (this.name != null) {
                Attribute nameAttr = new Attribute(Manifest.ATTRIBUTE_NAME, this.name);
                nameAttr.write(writer);
            }
            Enumeration<String> e = this.getAttributeKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Attribute attribute = this.getAttribute(key);
                attribute.write(writer, flatten);
            }
            writer.print(Manifest.EOL);
        }

        public Attribute getAttribute(String attributeName) {
            return this.attributes.get(attributeName.toLowerCase(Locale.ENGLISH));
        }

        public Enumeration<String> getAttributeKeys() {
            return CollectionUtils.asEnumeration(this.attributes.keySet().iterator());
        }

        public String getAttributeValue(String attributeName) {
            Attribute attribute = this.getAttribute(attributeName.toLowerCase(Locale.ENGLISH));
            if (attribute == null) {
                return null;
            }
            return attribute.getValue();
        }

        public void removeAttribute(String attributeName) {
            String key = attributeName.toLowerCase(Locale.ENGLISH);
            this.attributes.remove(key);
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String check = this.addAttributeAndCheck(attribute);
            if (check != null) {
                throw new BuildException("Specify the section name using the \"name\" attribute of the <section> element rather than using a \"Name\" manifest attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new BuildException("Attributes must have name and value");
            }
            String attributeKey = attribute.getKey();
            if (attributeKey.equals(ATTRIBUTE_NAME_LC)) {
                this.warnings.addElement("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attributeKey.startsWith(ATTRIBUTE_FROM_LC)) {
                this.warnings.addElement(Manifest.ERROR_FROM_FORBIDDEN + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else if (attributeKey.equals(ATTRIBUTE_CLASSPATH_LC)) {
                Attribute classpathAttribute = this.attributes.get(attributeKey);
                if (classpathAttribute == null) {
                    this.storeAttribute(attribute);
                } else {
                    this.warnings.addElement("Multiple Class-Path attributes are supported but violate the Jar specification and may not be correctly processed in all environments");
                    Enumeration<String> e = attribute.getValues();
                    while (e.hasMoreElements()) {
                        String value = e.nextElement();
                        classpathAttribute.addValue(value);
                    }
                }
            } else {
                if (this.attributes.containsKey(attributeKey)) {
                    throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not occur more " + "than once in the same section");
                }
                this.storeAttribute(attribute);
            }
            return null;
        }

        public Object clone() {
            Section cloned = new Section();
            cloned.setName(this.name);
            Enumeration<String> e = this.getAttributeKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Attribute attribute = this.getAttribute(key);
                cloned.storeAttribute(new Attribute(attribute.getName(), attribute.getValue()));
            }
            return cloned;
        }

        private void storeAttribute(Attribute attribute) {
            if (attribute == null) {
                return;
            }
            String attributeKey = attribute.getKey();
            this.attributes.put(attributeKey, attribute);
        }

        public Enumeration<String> getWarnings() {
            return this.warnings.elements();
        }

        public int hashCode() {
            return this.attributes.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Section rhsSection = (Section)rhs;
            return this.attributes.equals(rhsSection.attributes);
        }

        static /* synthetic */ void access$300(Section x0, Attribute x1) {
            x0.storeAttribute(x1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute {
        private static final int MAX_NAME_VALUE_LENGTH = 68;
        private static final int MAX_NAME_LENGTH = 70;
        private String name = null;
        private Vector<String> values = new Vector();
        private int currentIndex = 0;

        public Attribute() {
        }

        public Attribute(String line) throws ManifestException {
            this.parse(line);
        }

        public Attribute(String name, String value) {
            this.name = name;
            this.setValue(value);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.name != null) {
                hashCode += this.getKey().hashCode();
            }
            return hashCode += this.values.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Attribute rhsAttribute = (Attribute)rhs;
            String lhsKey = this.getKey();
            String rhsKey = rhsAttribute.getKey();
            if (lhsKey == null && rhsKey != null || lhsKey != null && !lhsKey.equals(rhsKey)) {
                return false;
            }
            return this.values.equals(rhsAttribute.values);
        }

        public void parse(String line) throws ManifestException {
            int index = line.indexOf(": ");
            if (index == -1) {
                throw new ManifestException("Manifest line \"" + line + "\" is not valid as it does not " + "contain a name and a value separated by ': ' ");
            }
            this.name = line.substring(0, index);
            this.setValue(line.substring(index + 2));
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            if (this.name == null) {
                return null;
            }
            return this.name.toLowerCase(Locale.ENGLISH);
        }

        public void setValue(String value) {
            if (this.currentIndex >= this.values.size()) {
                this.values.addElement(value);
                this.currentIndex = this.values.size() - 1;
            } else {
                this.values.setElementAt(value, this.currentIndex);
            }
        }

        public String getValue() {
            if (this.values.size() == 0) {
                return null;
            }
            String fullValue = "";
            Enumeration<String> e = this.getValues();
            while (e.hasMoreElements()) {
                String value = e.nextElement();
                fullValue = fullValue + value + " ";
            }
            return fullValue.trim();
        }

        public void addValue(String value) {
            ++this.currentIndex;
            this.setValue(value);
        }

        public Enumeration<String> getValues() {
            return this.values.elements();
        }

        public void addContinuation(String line) {
            String currentValue = this.values.elementAt(this.currentIndex);
            this.setValue(currentValue + line.substring(1));
        }

        public void write(PrintWriter writer) throws IOException {
            this.write(writer, false);
        }

        public void write(PrintWriter writer, boolean flatten) throws IOException {
            if (!flatten) {
                Enumeration<String> e = this.getValues();
                while (e.hasMoreElements()) {
                    this.writeValue(writer, e.nextElement());
                }
            } else {
                this.writeValue(writer, this.getValue());
            }
        }

        private void writeValue(PrintWriter writer, String value) throws IOException {
            String line = null;
            int nameLength = this.name.getBytes(Manifest.JAR_ENCODING).length;
            if (nameLength > 68) {
                if (nameLength > 70) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + value);
                }
                writer.print(this.name + ": " + Manifest.EOL);
                line = " " + value;
            } else {
                line = this.name + ": " + value;
            }
            while (line.getBytes(Manifest.JAR_ENCODING).length > 70) {
                int breakIndex = 70;
                if (breakIndex >= line.length()) {
                    breakIndex = line.length() - 1;
                }
                String section = line.substring(0, breakIndex);
                while (section.getBytes(Manifest.JAR_ENCODING).length > 70 && breakIndex > 0) {
                    section = line.substring(0, --breakIndex);
                }
                if (breakIndex == 0) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + value);
                }
                writer.print(section + Manifest.EOL);
                line = " " + line.substring(breakIndex);
            }
            writer.print(line + Manifest.EOL);
        }
    }
}

