/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs.optional.javah;

import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.ProjectComponent;
import shadow.org.apache.tools.ant.taskdefs.optional.javah.Gcjh;
import shadow.org.apache.tools.ant.taskdefs.optional.javah.JavahAdapter;
import shadow.org.apache.tools.ant.taskdefs.optional.javah.Kaffeh;
import shadow.org.apache.tools.ant.taskdefs.optional.javah.SunJavah;
import shadow.org.apache.tools.ant.types.Path;
import shadow.org.apache.tools.ant.util.ClasspathUtils;
import shadow.org.apache.tools.ant.util.JavaEnvUtils;

public class JavahAdapterFactory {
    public static String getDefault() {
        if (JavaEnvUtils.isKaffe()) {
            return "kaffeh";
        }
        if (JavaEnvUtils.isGij()) {
            return "gcjh";
        }
        return "sun";
    }

    public static JavahAdapter getAdapter(String choice, ProjectComponent log) throws BuildException {
        return JavahAdapterFactory.getAdapter(choice, log, null);
    }

    public static JavahAdapter getAdapter(String choice, ProjectComponent log, Path classpath) throws BuildException {
        if (JavaEnvUtils.isKaffe() && choice == null || "kaffeh".equals(choice)) {
            return new Kaffeh();
        }
        if (JavaEnvUtils.isGij() && choice == null || "gcjh".equals(choice)) {
            return new Gcjh();
        }
        if ("sun".equals(choice)) {
            return new SunJavah();
        }
        if (choice != null) {
            return JavahAdapterFactory.resolveClassName(choice, log.getProject().createClassLoader(classpath));
        }
        return new SunJavah();
    }

    private static JavahAdapter resolveClassName(String className, ClassLoader loader) throws BuildException {
        return (JavahAdapter)ClasspathUtils.newInstance(className, loader != null ? loader : JavahAdapterFactory.class.getClassLoader(), JavahAdapter.class);
    }
}

