/*
 * Decompiled with CFR 0.152.
 */
package javinator9889.localemanager.utils;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import java.util.Locale;

public class Utils {
    public static boolean isAtLeastAndroidVersion(int version) {
        return Build.VERSION.SDK_INT >= version;
    }

    public static Locale getLocale(@NonNull Resources resources) {
        Configuration config = resources.getConfiguration();
        return Utils.isAtLeastAndroidVersion(24) ? config.getLocales().get(0) : config.locale;
    }

    public static Locale getSystemLocale(@NonNull Configuration config) {
        return Utils.isAtLeastAndroidVersion(24) ? config.getLocales().get(0) : config.locale;
    }

    public static void resetActivityTitle(@NonNull Activity activity) {
        try {
            ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 128);
            if (info.labelRes != 0) {
                activity.setTitle(info.labelRes);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }
}

