/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.pool;

import com.github.jasync.sql.db.ConcreteConnection;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.ConnectionPoolConfiguration;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.interceptor.ConnectionInterceptorHelperKt;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.pool.ActorBasedObjectPool;
import com.github.jasync.sql.db.pool.AsyncObjectPool;
import com.github.jasync.sql.db.pool.ConnectionPoolKt;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.pool.PooledObject;
import com.github.jasync.sql.db.util.FP;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u001f\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u00162\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0016\"\u0004\b\u0001\u0010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00160\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010#\u001a\u00020$H\u0016J.\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00162\u0006\u0010#\u001a\u00020$2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(2\u0006\u0010*\u001a\u00020!H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\u00162\u0006\u0010#\u001a\u00020$H\u0016J\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/github/jasync/sql/db/pool/ConnectionPool;", "T", "Lcom/github/jasync/sql/db/ConcreteConnection;", "Lcom/github/jasync/sql/db/Connection;", "factory", "Lcom/github/jasync/sql/db/pool/ObjectFactory;", "configuration", "Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;", "(Lcom/github/jasync/sql/db/pool/ObjectFactory;Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;)V", "getConfiguration", "()Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;", "futuresWaitingForConnectionCount", "", "getFuturesWaitingForConnectionCount", "()I", "idleConnectionsCount", "getIdleConnectionsCount", "inUseConnectionsCount", "getInUseConnectionsCount", "objectPool", "Lcom/github/jasync/sql/db/pool/ActorBasedObjectPool;", "connect", "Ljava/util/concurrent/CompletableFuture;", "disconnect", "giveBack", "Lcom/github/jasync/sql/db/pool/AsyncObjectPool;", "item", "(Lcom/github/jasync/sql/db/ConcreteConnection;)Ljava/util/concurrent/CompletableFuture;", "inTransaction", "A", "f", "Lkotlin/Function1;", "isConnected", "", "releasePreparedStatement", "query", "", "sendPreparedStatement", "Lcom/github/jasync/sql/db/QueryResult;", "values", "", "", "release", "sendQuery", "take", "jasync-common"})
public final class ConnectionPool<T extends ConcreteConnection>
implements Connection {
    private final ActorBasedObjectPool<T> objectPool;
    @NotNull
    private final ConnectionPoolConfiguration configuration;

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendQuery(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return ConnectionInterceptorHelperKt.wrapQueryWithInterceptors(query, this.configuration.getInterceptors(), (Function1<? super String, ? extends CompletableFuture<QueryResult>>)((Function1)new Function1<String, CompletableFuture<QueryResult>>(this){
            final /* synthetic */ ConnectionPool this$0;

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull String q) {
                Intrinsics.checkParameterIsNotNull((Object)q, (String)"q");
                return ConnectionPool.access$getObjectPool$p(this.this$0).use(this.this$0.getConfiguration().getExecutionContext(), (Function1)new Function1<T, CompletableFuture<QueryResult>>(q){
                    final /* synthetic */ String $q;

                    @NotNull
                    public final CompletableFuture<QueryResult> invoke(@NotNull T connection) {
                        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
                        return connection.sendQueryDirect(this.$q);
                    }
                    {
                        this.$q = string;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = connectionPool;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values, boolean release) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return ConnectionInterceptorHelperKt.wrapPreparedStatementWithInterceptors(new PreparedStatementParams(query, values, release), this.configuration.getInterceptors(), (Function1<? super PreparedStatementParams, ? extends CompletableFuture<QueryResult>>)((Function1)new Function1<PreparedStatementParams, CompletableFuture<QueryResult>>(this){
            final /* synthetic */ ConnectionPool this$0;

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull PreparedStatementParams params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                return ConnectionPool.access$getObjectPool$p(this.this$0).use(this.this$0.getConfiguration().getExecutionContext(), (Function1)new Function1<T, CompletableFuture<QueryResult>>(params){
                    final /* synthetic */ PreparedStatementParams $params;

                    @NotNull
                    public final CompletableFuture<QueryResult> invoke(@NotNull T connection) {
                        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
                        return connection.sendPreparedStatementDirect(this.$params);
                    }
                    {
                        this.$params = preparedStatementParams;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = connectionPool;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> releasePreparedStatement(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return FP.INSTANCE.successful(false);
    }

    @Override
    @NotNull
    public <A> CompletableFuture<A> inTransaction(@NotNull Function1<? super Connection, ? extends CompletableFuture<A>> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.objectPool.use(this.configuration.getExecutionContext(), (Function1)new Function1<T, CompletableFuture<A>>(f){
            final /* synthetic */ Function1 $f;

            @NotNull
            public final CompletableFuture<A> invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return it.inTransaction(this.$f);
            }
            {
                this.$f = function1;
                super(1);
            }
        });
    }

    public final int getInUseConnectionsCount() {
        return this.objectPool.getUsedItemsSize();
    }

    public final int getFuturesWaitingForConnectionCount() {
        return this.objectPool.getWaitingForItemSize();
    }

    public final int getIdleConnectionsCount() {
        return this.objectPool.getAvailableItemsSize();
    }

    @NotNull
    public final CompletableFuture<T> take() {
        return this.objectPool.take();
    }

    @NotNull
    public final CompletableFuture<AsyncObjectPool<T>> giveBack(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        return this.objectPool.giveBack((PooledObject)item);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<Connection> disconnect() {
        CompletionStage<Connection> completionStage;
        if (this.isConnected()) {
            void $receiver$iv;
            CompletableFuture<AsyncObjectPool<T>> completableFuture = this.objectPool.close();
            Executor executor$iv = this.configuration.getExecutionContext();
            boolean $i$f$mapAsync = false;
            CompletionStage completionStage2 = $receiver$iv.thenApplyAsync(new Function<AsyncObjectPool<T>, Connection>(this){
                final /* synthetic */ ConnectionPool this$0;
                {
                    this.this$0 = connectionPool;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object apply(Object it) {
                    AsyncObjectPool it2 = (AsyncObjectPool)it;
                    boolean bl = false;
                    return this.this$0;
                }
            }, executor$iv);
            completionStage = completionStage2;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage2, (String)"thenApplyAsync(Function { f(it) }, executor)");
        } else {
            CompletableFuture<Connection> completableFuture = CompletableFuture.completedFuture(this);
            completionStage = completableFuture;
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(this)");
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<Connection> connect() {
        CompletableFuture<Connection> completableFuture = CompletableFuture.completedFuture(this);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(this)");
        return completableFuture;
    }

    @Override
    public boolean isConnected() {
        return !this.objectPool.getClosed();
    }

    @NotNull
    public final ConnectionPoolConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConnectionPool(@NotNull ObjectFactory<T> factory, @NotNull ConnectionPoolConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.objectPool = new ActorBasedObjectPool<T>(factory, this.configuration.getPoolConfiguration());
        ConnectionPoolKt.access$getLogger$p().debug((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return "pool created with configuration " + this.getConfiguration();
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return Connection.DefaultImpls.sendPreparedStatement(this, query, values);
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return Connection.DefaultImpls.sendPreparedStatement(this, query);
    }

    public static final /* synthetic */ ActorBasedObjectPool access$getObjectPool$p(ConnectionPool $this) {
        return $this.objectPool;
    }
}

