/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/jasync/sql/db/column/LocalDateTimeEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "ZeroedTimestamp", "", "format", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "optional", "Lorg/joda/time/format/DateTimeParser;", "decode", "Lorg/joda/time/LocalDateTime;", "value", "encode", "", "jasync-common"})
public final class LocalDateTimeEncoderDecoder
implements ColumnEncoderDecoder {
    private static final String ZeroedTimestamp = "0000-00-00 00:00:00";
    private static final DateTimeParser optional;
    private static final DateTimeFormatter format;
    public static final LocalDateTimeEncoderDecoder INSTANCE;

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = format.print((ReadablePartial)((LocalDateTime)value));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format.print(value as LocalDateTime)");
        return string;
    }

    @Nullable
    public LocalDateTime decode(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)ZeroedTimestamp, (Object)value) ? null : format.parseLocalDateTime(value);
    }

    private LocalDateTimeEncoderDecoder() {
    }

    static {
        LocalDateTimeEncoderDecoder localDateTimeEncoderDecoder;
        INSTANCE = localDateTimeEncoderDecoder = new LocalDateTimeEncoderDecoder();
        ZeroedTimestamp = ZeroedTimestamp;
        optional = new DateTimeFormatterBuilder().appendPattern(".SSSSSS").toParser();
        format = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(optional).toFormatter();
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }
}

