/*
 * Decompiled with CFR 0.152.
 */
package net.rimoto.intlphoneinput;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import net.rimoto.intlphoneinput.Country;
import net.rimoto.intlphoneinput.R;

public class CountrySpinnerAdapter
extends ArrayAdapter<Country> {
    private LayoutInflater mLayoutInflater;

    public CountrySpinnerAdapter(Context context) {
        super(context, 0);
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mLayoutInflater.inflate(R.layout.item_country, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.mImageView = (ImageView)convertView.findViewById(R.id.intl_phone_edit__country__item_image);
            viewHolder.mNameView = (TextView)convertView.findViewById(R.id.intl_phone_edit__country__item_name);
            viewHolder.mDialCode = (TextView)convertView.findViewById(R.id.intl_phone_edit__country__item_dialcode);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        Country country = (Country)this.getItem(position);
        viewHolder.mImageView.setImageResource(this.getFlagResource(country));
        viewHolder.mNameView.setText((CharSequence)country.getName());
        viewHolder.mDialCode.setText((CharSequence)String.format("+%s", country.getDialCode()));
        return convertView;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Country country = (Country)this.getItem(position);
        if (convertView == null) {
            convertView = new ImageView(this.getContext());
        }
        ((ImageView)convertView).setImageResource(this.getFlagResource(country));
        return convertView;
    }

    private int getFlagResource(Country country) {
        return this.getContext().getResources().getIdentifier("country_" + country.getIso().toLowerCase(), "drawable", this.getContext().getPackageName());
    }

    private static class ViewHolder {
        public ImageView mImageView;
        public TextView mNameView;
        public TextView mDialCode;

        private ViewHolder() {
        }
    }
}

