/*
 * Decompiled with CFR 0.152.
 */
package net.rimoto.intlphoneinput;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PorterDuff;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Locale;
import net.rimoto.intlphoneinput.CountriesFetcher;
import net.rimoto.intlphoneinput.Country;
import net.rimoto.intlphoneinput.CountrySpinnerAdapter;
import net.rimoto.intlphoneinput.R;

public class IntlPhoneInput
extends LinearLayout {
    private final String DEFAULT_COUNTRY = Locale.getDefault().getCountry();
    private Spinner mCountrySpinner;
    private EditText mPhoneEdit;
    private CountrySpinnerAdapter mCountrySpinnerAdapter;
    private PhoneNumberWatcher mPhoneNumberWatcher = new PhoneNumberWatcher(this.DEFAULT_COUNTRY);
    private PhoneNumberUtil mPhoneUtil = PhoneNumberUtil.getInstance();
    private Country mSelectedCountry;
    private CountriesFetcher.CountryList mCountries;
    private IntlPhoneInputListener mIntlPhoneInputListener;
    private AdapterView.OnItemSelectedListener mCountrySpinnerListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
            IntlPhoneInput.this.mSelectedCountry = (Country)IntlPhoneInput.this.mCountrySpinnerAdapter.getItem(position);
            IntlPhoneInput.this.mPhoneNumberWatcher = new PhoneNumberWatcher(IntlPhoneInput.this.mSelectedCountry.getIso());
            IntlPhoneInput.this.setHint();
            if (IntlPhoneInput.this.mIntlPhoneInputListener != null) {
                IntlPhoneInput.this.mIntlPhoneInputListener.onCountryChange(IntlPhoneInput.this.mSelectedCountry.getIso().toUpperCase());
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    };

    public IntlPhoneInput(Context context) {
        super(context);
        this.init();
    }

    public IntlPhoneInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        IntlPhoneInput.inflate((Context)this.getContext(), (int)R.layout.intl_phone_input, (ViewGroup)this);
        this.mCountrySpinner = (Spinner)this.findViewById(R.id.intl_phone_edit__country);
        this.mCountrySpinnerAdapter = new CountrySpinnerAdapter(this.getContext());
        this.mCountrySpinner.setAdapter((SpinnerAdapter)this.mCountrySpinnerAdapter);
        this.mCountries = CountriesFetcher.getCountries(this.getContext());
        this.mCountrySpinnerAdapter.addAll(this.mCountries);
        this.mCountrySpinner.setOnItemSelectedListener(this.mCountrySpinnerListener);
        this.mPhoneEdit = (EditText)this.findViewById(R.id.intl_phone_edit__phone);
        this.mPhoneEdit.addTextChangedListener((TextWatcher)this.mPhoneNumberWatcher);
        this.mPhoneEdit.getBackground().mutate().setColorFilter(-1, PorterDuff.Mode.SRC_ATOP);
        this.setDefault();
    }

    public void hideKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getApplicationContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(this.mPhoneEdit.getWindowToken(), 0);
    }

    public void showKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getApplicationContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mPhoneEdit, 0);
    }

    public void setDefault() {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.getContext().getSystemService("phone");
            String phone = telephonyManager.getLine1Number();
            if (phone != null && !phone.isEmpty()) {
                this.setNumber(phone);
            } else {
                String iso = telephonyManager.getNetworkCountryIso();
                this.setEmptyDefault(iso);
            }
        }
        catch (SecurityException e) {
            this.setEmptyDefault();
        }
    }

    public void setEmptyDefault(String iso) {
        if (iso == null || iso.isEmpty()) {
            iso = this.DEFAULT_COUNTRY;
        }
        int defaultIdx = this.mCountries.indexOfIso(iso);
        this.mSelectedCountry = (Country)this.mCountries.get(defaultIdx);
        this.mCountrySpinner.setSelection(defaultIdx);
    }

    private void setEmptyDefault() {
        this.setEmptyDefault(null);
    }

    private void setHint() {
        Phonenumber.PhoneNumber phoneNumber;
        if (this.mPhoneEdit != null && this.mSelectedCountry != null && this.mSelectedCountry.getIso() != null && (phoneNumber = this.mPhoneUtil.getExampleNumberForType(this.mSelectedCountry.getIso(), PhoneNumberUtil.PhoneNumberType.MOBILE)) != null) {
            this.mPhoneEdit.setHint((CharSequence)this.mPhoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        }
    }

    public void setHint(String hint) {
        if (!TextUtils.isEmpty((CharSequence)hint) && this.mPhoneEdit != null) {
            this.mPhoneEdit.setHint((CharSequence)hint);
        }
    }

    public void setNumber(String number) {
        try {
            String iso = null;
            if (this.mSelectedCountry != null) {
                iso = this.mSelectedCountry.getIso();
            }
            Phonenumber.PhoneNumber phoneNumber = this.mPhoneUtil.parse(number, iso);
            int countryIdx = this.mCountries.indexOfIso(this.mPhoneUtil.getRegionCodeForNumber(phoneNumber));
            this.mCountrySpinner.setSelection(countryIdx);
            this.mPhoneEdit.setText((CharSequence)this.mPhoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
    }

    public String getNumber() {
        Phonenumber.PhoneNumber phoneNumber = this.getPhoneNumber();
        if (phoneNumber == null) {
            return null;
        }
        return this.mPhoneUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    public String getText() {
        return this.getNumber();
    }

    public Phonenumber.PhoneNumber getPhoneNumber() {
        try {
            String iso = null;
            if (this.mSelectedCountry != null) {
                iso = this.mSelectedCountry.getIso();
            }
            return this.mPhoneUtil.parse(this.mPhoneEdit.getText().toString(), iso);
        }
        catch (NumberParseException ignored) {
            return null;
        }
    }

    public Country getSelectedCountry() {
        return this.mSelectedCountry;
    }

    public boolean isValid() {
        Phonenumber.PhoneNumber phoneNumber = this.getPhoneNumber();
        return phoneNumber != null && this.mPhoneUtil.isValidNumber(phoneNumber);
    }

    public void setOnValidityChange(IntlPhoneInputListener listener) {
        this.mIntlPhoneInputListener = listener;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mPhoneEdit.setEnabled(enabled);
        this.mCountrySpinner.setEnabled(enabled);
    }

    public void setOnKeyboardDone(final IntlPhoneInputListener listener) {
        this.mPhoneEdit.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    listener.done((View)IntlPhoneInput.this, IntlPhoneInput.this.isValid());
                }
                return false;
            }
        });
    }

    public static interface IntlPhoneInputListener {
        public void done(View var1, boolean var2);

        public void onCountryChange(String var1);
    }

    private class PhoneNumberWatcher
    extends PhoneNumberFormattingTextWatcher {
        private boolean lastValidity;

        public PhoneNumberWatcher() {
        }

        @TargetApi(value=21)
        public PhoneNumberWatcher(String countryCode) {
            super(countryCode);
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            super.onTextChanged(s, start, before, count);
            try {
                String iso = null;
                if (IntlPhoneInput.this.mSelectedCountry != null) {
                    iso = IntlPhoneInput.this.mSelectedCountry.getIso();
                }
                Phonenumber.PhoneNumber phoneNumber = IntlPhoneInput.this.mPhoneUtil.parse(s.toString(), iso);
                iso = IntlPhoneInput.this.mPhoneUtil.getRegionCodeForNumber(phoneNumber);
                if (iso != null) {
                    int countryIdx = IntlPhoneInput.this.mCountries.indexOfIso(iso);
                    IntlPhoneInput.this.mCountrySpinner.setSelection(countryIdx);
                }
            }
            catch (NumberParseException iso) {
                // empty catch block
            }
            if (IntlPhoneInput.this.mIntlPhoneInputListener != null) {
                boolean validity = IntlPhoneInput.this.isValid();
                if (validity != this.lastValidity) {
                    IntlPhoneInput.this.mIntlPhoneInputListener.done((View)IntlPhoneInput.this, validity);
                }
                this.lastValidity = validity;
            }
        }
    }
}

