/*
 * Decompiled with CFR 0.152.
 */
package net.rimoto.intlphoneinput;

import android.content.Context;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.rimoto.intlphoneinput.Country;
import net.rimoto.intlphoneinput.R;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CountriesFetcher {
    private static CountryList mCountries;

    private static String getJsonFromRaw(Context context, int resource) {
        String json;
        try {
            InputStream inputStream = context.getResources().openRawResource(resource);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            json = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public static CountryList getCountries(Context context) {
        if (mCountries != null) {
            return mCountries;
        }
        mCountries = new CountryList();
        try {
            JSONArray countries = new JSONArray(CountriesFetcher.getJsonFromRaw(context, R.raw.countries));
            for (int i = 0; i < countries.length(); ++i) {
                try {
                    JSONObject country = (JSONObject)countries.get(i);
                    mCountries.add(new Country(country.getString("name"), country.getString("iso2"), country.getInt("dialCode")));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mCountries;
    }

    public static class CountryList
    extends ArrayList<Country> {
        public int indexOfIso(String iso) {
            for (int i = 0; i < this.size(); ++i) {
                Country country = (Country)this.get(i);
                if (country == null || TextUtils.isEmpty((CharSequence)country.getIso()) || !country.getIso().toUpperCase().equals(iso.toUpperCase())) continue;
                return i;
            }
            return -1;
        }

        public int indexOfDialCode(int dialCode) {
            for (int i = 0; i < this.size(); ++i) {
                if (((Country)this.get(i)).getDialCode() != dialCode) continue;
                return i;
            }
            return -1;
        }
    }
}

