/*
 * Decompiled with CFR 0.152.
 */
package in.ishankhanna.tinglingsquares;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;

public class SquareView
extends View {
    private int s;
    private int p;
    private Paint paint;
    private float left;
    private float top;
    private float right;
    private float bottom;
    private final int row;
    private final int col;
    private float originX = 40.0f;
    private float originY = 40.0f;

    public SquareView(Context context, int row, int col) {
        super(context);
        this.row = row;
        this.col = col;
        this.init();
    }

    private void init() {
        this.s = 40;
        this.p = 8;
        this.paint = new Paint(1);
        this.paint.setColor(-1);
        this.top = this.originY + (float)(this.row * this.s) + (float)(this.row * this.p);
        this.left = this.originX + (float)(this.col * this.s) + (float)(this.col * this.p);
        this.bottom = this.top + (float)this.s;
        this.right = this.left + (float)this.s;
        this.setPivot();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.d((String)"ContentValues", (String)("onDraw() called with: canvas = [" + canvas + "]"));
        canvas.drawRect(this.left, this.top, this.right, this.bottom, this.paint);
    }

    private void setPivot() {
        float pX = this.right;
        float pY = this.bottom;
        this.setPivotX(pX);
        this.setPivotY(pY);
    }
}

