/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;

public class CustomQuoteSpan
implements LeadingMarginSpan,
LineBackgroundSpan {
    private final int backgroundColor;
    private final int stripeColor;
    private final float stripeWidth;
    private final float gap;

    public CustomQuoteSpan(int backgroundColor, int stripeColor, float stripeWidth, float gap) {
        this.backgroundColor = backgroundColor;
        this.stripeColor = stripeColor;
        this.stripeWidth = stripeWidth;
        this.gap = gap;
    }

    public int getLeadingMargin(boolean first) {
        return (int)(this.stripeWidth + this.gap);
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        Paint.Style style = p.getStyle();
        int paintColor = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.stripeColor);
        c.drawRect((float)x, (float)top, (float)x + (float)dir * this.stripeWidth, (float)bottom, p);
        p.setStyle(style);
        p.setColor(paintColor);
    }

    public void drawBackground(Canvas c, Paint p, int left, int right, int top, int baseline, int bottom, CharSequence text, int start, int end, int lnum) {
        int paintColor = p.getColor();
        p.setColor(this.backgroundColor);
        c.drawRect((float)left, (float)top, (float)right, (float)bottom, p);
        p.setColor(paintColor);
    }
}

