/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.text.Editable;
import android.view.View;
import android.widget.ImageView;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorComponent;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.Utilities.Utilities;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.RenderType;
import org.jsoup.nodes.Element;

public class MapExtensions
extends EditorComponent {
    EditorCore editorCore;
    private int mapExtensionTemplate = R.layout.tmpl_image_view;

    @Override
    public Node getContent(View view) {
        Node node = this.getNodeInstance(view);
        EditorControl mapTag = (EditorControl)view.getTag();
        Editable desc = ((CustomEditText)view.findViewById(R.id.desc)).getText();
        node.content.add(mapTag.Cords);
        node.content.add(desc.length() > 0 ? desc.toString() : "");
        return node;
    }

    @Override
    public String getContentAsHTML(Node node, EditorContent content) {
        return this.componentsWrapper.getHtmlExtensions().getTemplateHtml(node.type).replace("{{$content}}", this.componentsWrapper.getMapExtensions().getCordsAsUri(node.content.get(0))).replace("{{$desc}}", node.content.get(1));
    }

    @Override
    public void renderEditorFromState(Node node, EditorContent content) {
        this.insertMap(node.content.get(0), node.content.get(1), true);
    }

    @Override
    public Node buildNodeFromHTML(Element element) {
        return null;
    }

    @Override
    public void init(ComponentsWrapper componentsWrapper) {
        this.componentsWrapper = componentsWrapper;
    }

    public MapExtensions(EditorCore editorCore) {
        super(editorCore);
        this.editorCore = editorCore;
    }

    public void setMapViewTemplate(int drawable2) {
        this.mapExtensionTemplate = drawable2;
    }

    public String getMapStaticImgUri(String cords, int width) {
        StringBuilder builder = new StringBuilder();
        builder.append("http://maps.google.com/maps/api/staticmap?");
        builder.append("size=" + String.valueOf(width) + "x400&zoom=15&sensor=true&markers=" + cords);
        return builder.toString();
    }

    public void insertMap(String cords, String desc, boolean insertEditText) {
        String[] x = cords.split(",");
        String lat = x[0];
        String lng = x[1];
        int[] size = Utilities.getScreenDimension(this.editorCore.getContext());
        int width = size[0];
        final View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.mapExtensionTemplate, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        this.componentsWrapper.getImageExtensions().loadImageUsingLib(this.getMapStaticImgUri(String.valueOf(lat) + "," + String.valueOf(lng), width), imageView);
        CustomEditText editText = (CustomEditText)childLayout.findViewById(R.id.desc);
        if (this.editorCore.getRenderType() == RenderType.Renderer) {
            editText.setText(desc);
            editText.setEnabled(false);
        }
        final View btn = childLayout.findViewById(R.id.btn_remove);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn.setVisibility(hasFocus ? 0 : 4);
            }
        });
        btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapExtensions.this.editorCore.getParentView().removeView(childLayout);
            }
        });
        EditorControl control = this.editorCore.createTag(EditorType.map);
        control.Cords = cords;
        childLayout.setTag((Object)control);
        int Index = this.editorCore.determineIndex(EditorType.map);
        this.editorCore.getParentView().addView(childLayout, Index);
        if (insertEditText) {
            this.componentsWrapper.getInputExtensions().insertEditText(Index + 1, null, null);
        }
    }

    public void loadMapActivity() {
    }

    public CharSequence getCordsAsUri(String s) {
        return this.getMapStaticImgUri(s, 800);
    }
}

