/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.EditorComponent;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.Utilities.Utilities;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.RenderType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;

public class MacroExtensions
extends EditorComponent {
    private final EditorCore editorCore;

    public MacroExtensions(EditorCore editorCore) {
        super(editorCore);
        this.editorCore = editorCore;
    }

    public void insertMacro(String name, View view, Map<String, Object> settings, int index) {
        final FrameLayout frameLayout = new FrameLayout(this.editorCore.getContext());
        frameLayout.addView(view);
        final FrameLayout overlay = new FrameLayout(frameLayout.getContext());
        overlay.setVisibility(8);
        overlay.setPadding(0, 0, 20, 0);
        overlay.setBackgroundColor(Color.argb((int)50, (int)0, (int)0, (int)0));
        ImageView imageView = new ImageView(overlay.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(Utilities.dpToPx(frameLayout.getContext(), 40.0f), Utilities.dpToPx(frameLayout.getContext(), 40.0f));
        params.gravity = 21;
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        imageView.setImageResource(R.drawable.ic_close_white_36dp);
        overlay.addView((View)imageView);
        frameLayout.addView((View)overlay);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MacroExtensions.this.editorCore.getParentView().removeView((View)frameLayout);
            }
        });
        EditorControl control = this.editorCore.createTag(EditorType.macro);
        control.macroSettings = settings;
        control.macroName = name;
        if (index == -1) {
            index = this.editorCore.determineIndex(EditorType.macro);
        }
        frameLayout.setTag((Object)control);
        this.editorCore.getParentView().addView((View)frameLayout, index);
        if (this.editorCore.getRenderType() == RenderType.Renderer) {
            return;
        }
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (event.getAction() == 1) {
                    int paddingTop = view.getPaddingTop();
                    int paddingBottom = view.getPaddingBottom();
                    int height = view.getHeight();
                    if (event.getY() < (float)paddingTop) {
                        MacroExtensions.this.editorCore.___onViewTouched(0, MacroExtensions.this.editorCore.getParentView().indexOfChild((View)frameLayout));
                    } else if (event.getY() > (float)(height - paddingBottom)) {
                        MacroExtensions.this.editorCore.___onViewTouched(1, MacroExtensions.this.editorCore.getParentView().indexOfChild((View)frameLayout));
                    } else if (overlay.getVisibility() == 0) {
                        overlay.setVisibility(8);
                    } else {
                        overlay.setVisibility(0);
                    }
                    return false;
                }
                return true;
            }
        });
        frameLayout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (!b) {
                    overlay.setVisibility(8);
                }
            }
        });
    }

    @Override
    public Node getContent(View view) {
        Node node = this.getNodeInstance(view);
        EditorControl macroTag = (EditorControl)view.getTag();
        node.content.add(macroTag.macroName);
        node.macroSettings = macroTag.macroSettings;
        return node;
    }

    @Override
    public String getContentAsHTML(Node node, EditorContent content) {
        return this.getAsHtml(node.content.get(0), node.macroSettings);
    }

    private String getAsHtml(String name, Map<String, Object> macroSettings) {
        String template = "<{{$tag}} data-tag=\"macro\" {{$settings}}></{{$tag}}>";
        template = template.replace("{{$tag}}", name);
        StringBuilder dataTags = new StringBuilder();
        for (Map.Entry<String, Object> item : macroSettings.entrySet()) {
            if (item.getKey().equalsIgnoreCase("data-tag")) continue;
            dataTags.append(" ");
            if (item.getKey().contains("data-")) {
                dataTags.append(item.getKey());
            } else {
                dataTags.append("data-" + item.getKey());
            }
            dataTags.append("=\"").append(String.valueOf(item.getValue())).append("\"");
        }
        template = TextUtils.isEmpty((CharSequence)dataTags) ? template.replace("{{$settings}}", "") : template.replace("{{$settings}}", dataTags.toString());
        return template;
    }

    @Override
    public void renderEditorFromState(Node node, EditorContent content) {
        int index = this.editorCore.getChildCount();
        View view = this.editorCore.getEditorListener().onRenderMacro(node.content.get(0), node.macroSettings, this.editorCore.getChildCount());
        if (view == null) {
            view = this.getEmptyMacro(node.content.get(0), node.macroSettings);
        }
        this.insertMacro(node.content.get(0), view, node.macroSettings, index);
    }

    private View getEmptyMacro(String name, Map<String, Object> macroSettings) {
        View layout2 = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(R.layout.default_macro, null);
        TextView message = (TextView)layout2.findViewById(R.id.txtMessage);
        message.setText((CharSequence)("Unhandled macro \"" + this.getAsHtml(name, macroSettings) + "\""));
        return layout2;
    }

    @Override
    public Node buildNodeFromHTML(Element element) {
        String tag = element.tagName().toLowerCase();
        Node node = this.getNodeInstance(EditorType.macro);
        node.content.add(tag);
        List attrs = element.attributes().asList();
        if (!attrs.isEmpty()) {
            node.macroSettings = new HashMap<String, Object>();
            for (Attribute attr : attrs) {
                node.macroSettings.put(attr.getKey(), attr.getValue());
            }
        }
        int index = this.editorCore.getChildCount();
        View view = this.editorCore.getEditorListener().onRenderMacro(tag, node.macroSettings, this.editorCore.getChildCount());
        if (view == null) {
            view = this.getEmptyMacro(node.content.get(0), node.macroSettings);
        }
        this.insertMacro(tag, view, node.macroSettings, index);
        return null;
    }

    @Override
    public void init(ComponentsWrapper componentsWrapper) {
        this.componentsWrapper = componentsWrapper;
    }
}

