/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.text.Editable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.util.Linkify;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorComponent;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.Utilities.FontCache;
import com.github.irshulx.Utilities.Utilities;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.HtmlTag;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.Op;
import com.github.irshulx.models.RenderType;
import com.github.irshulx.models.TextSetting;
import com.github.irshulx.models.TextSettings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class InputExtensions
extends EditorComponent {
    public static final int HEADING = 0;
    public static final int CONTENT = 1;
    private String DEFAULT_TEXT_COLOR = "#000000";
    private int H1TEXTSIZE = 23;
    private int H2TEXTSIZE = 20;
    private int H3TEXTSIZE = 18;
    private int NORMALTEXTSIZE = 16;
    private int fontFace = R.string.fontFamily__serif;
    EditorCore editorCore;
    private Map<Integer, String> contentTypeface;
    private Map<Integer, String> headingTypeface;
    private float lineSpacing = -1.0f;

    public int getH1TextSize() {
        return this.H1TEXTSIZE;
    }

    public void setH1TextSize(int size) {
        this.H1TEXTSIZE = size;
    }

    public int getH2TextSize() {
        return this.H2TEXTSIZE;
    }

    public void setH2TextSize(int size) {
        this.H2TEXTSIZE = size;
    }

    public int getH3TextSize() {
        return this.H3TEXTSIZE;
    }

    public void setH3TextSize(int size) {
        this.H3TEXTSIZE = size;
    }

    public int getNormalTextSize() {
        return this.NORMALTEXTSIZE;
    }

    public void setNormalTextSize(int size) {
        this.NORMALTEXTSIZE = size;
    }

    public void setDefaultTextColor(String color) {
        this.DEFAULT_TEXT_COLOR = color;
    }

    public String getDefaultTextColor() {
        return this.DEFAULT_TEXT_COLOR;
    }

    public String getFontFace() {
        return this.editorCore.getContext().getResources().getString(this.fontFace);
    }

    public void setFontFace(int fontFace) {
        this.fontFace = fontFace;
    }

    public Map<Integer, String> getContentTypeface() {
        return this.contentTypeface;
    }

    public void setContentTypeface(Map<Integer, String> contentTypeface) {
        this.contentTypeface = contentTypeface;
    }

    public Map<Integer, String> getHeadingTypeface() {
        return this.headingTypeface;
    }

    public void setHeadingTypeface(Map<Integer, String> headingTypeface) {
        this.headingTypeface = headingTypeface;
    }

    @Override
    public Node getContent(View view) {
        Node node = this.getNodeInstance(view);
        EditText _text = (EditText)view;
        EditorControl tag = (EditorControl)view.getTag();
        node.contentStyles = tag.editorTextStyles;
        node.content.add(Html.toHtml((Spanned)_text.getText()));
        node.textSettings = tag.textSettings;
        return node;
    }

    @Override
    public String getContentAsHTML(Node node, EditorContent content) {
        String html = this.getInputHtml(node);
        return html;
    }

    @Override
    public void renderEditorFromState(Node node, EditorContent content) {
        String text = node.content.get(0);
        TextView view = this.insertEditText(this.editorCore.getChildCount(), this.editorCore.getPlaceHolder(), text);
        this.applyTextSettings(node, view);
    }

    @Override
    public Node buildNodeFromHTML(Element element) {
        HtmlTag tag = HtmlTag.valueOf(element.tagName().toLowerCase());
        switch (tag) {
            case h1: 
            case h2: 
            case h3: {
                this.RenderHeader(tag, element);
                break;
            }
            case p: 
            case div: {
                String text = element.html();
                int count = this.editorCore.getParentView().getChildCount();
                TextView textView = this.insertEditText(count, null, text);
                this.applyStyles(textView, element);
            }
        }
        return null;
    }

    @Override
    public void init(ComponentsWrapper componentsWrapper) {
        this.componentsWrapper = componentsWrapper;
    }

    public InputExtensions(EditorCore editorCore) {
        super(editorCore);
        this.editorCore = editorCore;
    }

    CharSequence GetSanitizedHtml(CharSequence text) {
        Spanned __ = Html.fromHtml((String)text.toString());
        CharSequence toReplace = this.noTrailingwhiteLines((CharSequence)__);
        return toReplace;
    }

    public void setText(TextView textView, CharSequence text) {
        CharSequence toReplace = this.GetSanitizedHtml(text);
        textView.setText(toReplace);
    }

    private TextView getNewTextView(CharSequence text) {
        TextView textView = new TextView((Context)new ContextThemeWrapper(this.editorCore.getContext(), R.style.WysiwygEditText));
        this.addEditableStyling(textView);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, 0, (int)this.editorCore.getContext().getResources().getDimension(R.dimen.edittext_margin_bottom));
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Spanned __ = Html.fromHtml((String)text.toString());
            CharSequence toReplace = this.noTrailingwhiteLines((CharSequence)__);
            textView.setText(toReplace);
            Linkify.addLinks((TextView)textView, (int)15);
        }
        if (this.lineSpacing != -1.0f) {
            this.setLineSpacing(textView, this.lineSpacing);
        }
        return textView;
    }

    public void setLineSpacing(TextView textView, float lineHeight) {
        int fontHeight = textView.getPaint().getFontMetricsInt(null);
        textView.setLineSpacing((float)(Utilities.dpToPx(this.editorCore.getContext(), lineHeight) - fontHeight), 1.0f);
    }

    public CustomEditText getNewEditTextInst(final String hint, CharSequence text) {
        final CustomEditText editText = new CustomEditText((Context)new ContextThemeWrapper(this.editorCore.getContext(), R.style.WysiwygEditText));
        this.addEditableStyling((TextView)editText);
        editText.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        if (hint != null) {
            editText.setHint(hint);
        }
        if (text != null) {
            this.setText((TextView)editText, text);
        }
        EditorControl editorTag = this.editorCore.createTag(EditorType.INPUT);
        editorTag.textSettings = new TextSettings(this.DEFAULT_TEXT_COLOR);
        editText.setTag(editorTag);
        editText.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.editorCore.getContext(), (int)R.drawable.invisible_edit_text));
        editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return InputExtensions.this.editorCore.onKey(v, keyCode, event, editText);
            }
        });
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    editText.clearFocus();
                } else {
                    InputExtensions.this.editorCore.setActiveView(v);
                }
            }
        });
        editText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                String text = Html.toHtml((Spanned)editText.getText());
                Object tag = editText.getTag(R.id.control_tag);
                if (s.length() == 0 && tag != null) {
                    editText.setHint(tag.toString());
                }
                if (s.length() > 0) {
                    for (int i = 0; i < s.length(); ++i) {
                        int index;
                        if (s.charAt(i) != '\n') continue;
                        CharSequence subChars = s.subSequence(0, i);
                        SpannableStringBuilder ssb = new SpannableStringBuilder(subChars);
                        text = Html.toHtml((Spanned)ssb);
                        if (text.length() > 0) {
                            InputExtensions.this.setText((TextView)editText, text);
                        }
                        if (i + 1 == s.length()) {
                            s.clear();
                        }
                        if ((index = InputExtensions.this.editorCore.getParentView().indexOfChild((View)editText)) == 0) {
                            editText.setHint(null);
                            editText.setTag(R.id.control_tag, hint);
                        }
                        int position = index + 1;
                        CharSequence newText = null;
                        SpannableStringBuilder editable = new SpannableStringBuilder();
                        int nextIndex = i + 1;
                        int lastIndex = s.length();
                        if (nextIndex < lastIndex) {
                            newText = s.subSequence(nextIndex, lastIndex);
                            for (int j = 0; j < newText.length(); ++j) {
                                editable.append(newText.charAt(j));
                                if (newText.charAt(j) != '\n') continue;
                                editable.append('\n');
                            }
                        }
                        InputExtensions.this.insertEditText(position, hint, (CharSequence)editable);
                        break;
                    }
                }
                if (InputExtensions.this.editorCore.getEditorListener() != null) {
                    InputExtensions.this.editorCore.getEditorListener().onTextChanged((EditText)editText, s);
                }
            }
        });
        if (this.lineSpacing != -1.0f) {
            this.setLineSpacing((TextView)editText, this.lineSpacing);
        }
        return editText;
    }

    private boolean isLastText(int index) {
        if (index == 0) {
            return false;
        }
        View view = this.editorCore.getParentView().getChildAt(index - 1);
        EditorType type = this.editorCore.getControlType(view);
        return type == EditorType.INPUT;
    }

    private void addEditableStyling(TextView editText) {
        editText.setTypeface(this.getTypeface(1, 0));
        editText.setFocusableInTouchMode(true);
        editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
        editText.setTextColor(Color.parseColor((String)this.DEFAULT_TEXT_COLOR));
    }

    private void getText(int index) {
        View view = this.editorCore.getParentView().getChildAt(index);
        EditorType type = this.editorCore.getControlType(view);
        if (type != EditorType.INPUT) {
            return;
        }
        TextView tv = (TextView)view;
        tv.setHint((CharSequence)this.editorCore.getPlaceHolder());
    }

    public TextView insertEditText(int position, String hint, CharSequence text) {
        String nextHint;
        String string2 = nextHint = this.isLastText(position) ? null : this.editorCore.getPlaceHolder();
        if (this.editorCore.getRenderType() == RenderType.Editor) {
            TextView textView;
            CustomEditText view;
            EditorType type;
            if (position == 1 && (type = this.editorCore.getControlType((View)(view = this.editorCore.getParentView().getChildAt(0)))) == EditorType.INPUT && TextUtils.isEmpty((CharSequence)(textView = (TextView)view).getText())) {
                textView.setHint(null);
            }
            view = this.getNewEditTextInst(nextHint, text);
            this.editorCore.getParentView().addView((View)view, position);
            this.editorCore.setActiveView((View)view);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputExtensions.this.setFocus(view);
                }
            }, 0L);
            this.editorCore.setActiveView((View)view);
            return view;
        }
        TextView view = this.getNewTextView(text);
        view.setTag((Object)this.editorCore.createTag(EditorType.INPUT));
        this.editorCore.getParentView().addView((View)view);
        return view;
    }

    private EditorControl reWriteTags(EditorControl tag, EditorTextStyle styleToAdd) {
        tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.H1, Op.Delete);
        tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.H2, Op.Delete);
        tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.H3, Op.Delete);
        tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.NORMAL, Op.Delete);
        tag = this.editorCore.updateTagStyle(tag, styleToAdd, Op.Insert);
        return tag;
    }

    public boolean isEditorTextStyleHeaders(EditorTextStyle editorTextStyle) {
        return editorTextStyle == EditorTextStyle.H1 || editorTextStyle == EditorTextStyle.H2 || editorTextStyle == EditorTextStyle.H3;
    }

    public boolean isEditorTextStyleContentStyles(EditorTextStyle editorTextStyle) {
        return editorTextStyle == EditorTextStyle.BOLD || editorTextStyle == EditorTextStyle.BOLDITALIC || editorTextStyle == EditorTextStyle.ITALIC;
    }

    public int getTextStyleFromStyle(EditorTextStyle editorTextStyle) {
        if (editorTextStyle == EditorTextStyle.H1) {
            return this.H1TEXTSIZE;
        }
        if (editorTextStyle == EditorTextStyle.H2) {
            return this.H2TEXTSIZE;
        }
        if (editorTextStyle == EditorTextStyle.H3) {
            return this.H3TEXTSIZE;
        }
        return this.NORMALTEXTSIZE;
    }

    private void updateTextStyle(TextView editText, EditorTextStyle editorTextStyle) {
        if (editText == null) {
            editText = (EditText)this.editorCore.getActiveView();
        }
        EditorControl editorControl = this.editorCore.getControlTag((View)editText);
        if (this.isEditorTextStyleHeaders(editorTextStyle)) {
            EditorControl tag;
            if (this.editorCore.containsStyle(editorControl.editorTextStyles, editorTextStyle)) {
                editText.setTextSize(2, (float)this.NORMALTEXTSIZE);
                editText.setTypeface(this.getTypeface(1, 0));
                tag = this.reWriteTags(editorControl, EditorTextStyle.NORMAL);
            } else {
                editText.setTextSize(2, (float)this.getTextStyleFromStyle(editorTextStyle));
                editText.setTypeface(this.getTypeface(0, 1));
                tag = this.reWriteTags(editorControl, editorTextStyle);
            }
            editText.setTag((Object)tag);
        }
    }

    private boolean containsHeaderTextStyle(EditorControl tag) {
        for (EditorTextStyle item : tag.editorTextStyles) {
            if (!this.isEditorTextStyleHeaders(item)) continue;
            return true;
        }
        return false;
    }

    public void boldifyText(EditorControl tag, TextView editText, int textMode) {
        if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.BOLD)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLD, Op.Delete);
            editText.setTypeface(this.getTypeface(textMode, 0));
        } else if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.BOLDITALIC)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Delete);
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.ITALIC, Op.Insert);
            editText.setTypeface(this.getTypeface(textMode, 2));
        } else if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.ITALIC)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Insert);
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.ITALIC, Op.Delete);
            editText.setTypeface(this.getTypeface(textMode, 3));
        } else {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLD, Op.Insert);
            editText.setTypeface(this.getTypeface(textMode, 1));
        }
        editText.setTag((Object)tag);
    }

    public void italicizeText(EditorControl tag, TextView editText, int textMode) {
        if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.ITALIC)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.ITALIC, Op.Delete);
            editText.setTypeface(this.getTypeface(textMode, 0));
        } else if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.BOLDITALIC)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Delete);
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLD, Op.Insert);
            editText.setTypeface(this.getTypeface(textMode, 1));
        } else if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.BOLD)) {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLDITALIC, Op.Insert);
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.BOLD, Op.Delete);
            editText.setTypeface(this.getTypeface(textMode, 3));
        } else {
            tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.ITALIC, Op.Insert);
            editText.setTypeface(this.getTypeface(textMode, 2));
        }
        editText.setTag((Object)tag);
    }

    public void UpdateTextStyle(EditorTextStyle style2, TextView editText) {
        try {
            if (editText == null) {
                editText = (EditText)this.editorCore.getActiveView();
            }
            EditorControl tag = this.editorCore.getControlTag((View)editText);
            if (this.isEditorTextStyleHeaders(style2)) {
                this.updateTextStyle(editText, style2);
                return;
            }
            if (this.isEditorTextStyleContentStyles(style2)) {
                boolean containsHeadertextStyle = this.containsHeaderTextStyle(tag);
                if (style2 == EditorTextStyle.BOLD) {
                    this.boldifyText(tag, editText, containsHeadertextStyle ? 0 : 1);
                } else if (style2 == EditorTextStyle.ITALIC) {
                    this.italicizeText(tag, editText, containsHeadertextStyle ? 0 : 1);
                }
                return;
            }
            if (style2 == EditorTextStyle.INDENT) {
                int pBottom = editText.getPaddingBottom();
                int pRight = editText.getPaddingRight();
                int pTop = editText.getPaddingTop();
                if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.INDENT)) {
                    tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.INDENT, Op.Delete);
                    editText.setPadding(0, pTop, pRight, pBottom);
                    editText.setTag((Object)tag);
                } else {
                    tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.INDENT, Op.Insert);
                    editText.setPadding(30, pTop, pRight, pBottom);
                    editText.setTag((Object)tag);
                }
            } else if (style2 == EditorTextStyle.OUTDENT) {
                int pBottom = editText.getPaddingBottom();
                int pRight = editText.getPaddingRight();
                int pTop = editText.getPaddingTop();
                if (this.editorCore.containsStyle(tag.editorTextStyles, EditorTextStyle.INDENT)) {
                    tag = this.editorCore.updateTagStyle(tag, EditorTextStyle.INDENT, Op.Delete);
                    editText.setPadding(0, pTop, pRight, pBottom);
                    editText.setTag((Object)tag);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertLink() {
        AlertDialog.Builder inputAlert = new AlertDialog.Builder(this.editorCore.getContext());
        inputAlert.setTitle((CharSequence)"Add a Link");
        final EditText userInput = new EditText(this.editorCore.getContext());
        userInput.setHint((CharSequence)"type the URL here");
        userInput.setInputType(160);
        inputAlert.setView((View)userInput);
        inputAlert.setPositiveButton((CharSequence)"Insert", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String userInputValue = userInput.getText().toString();
                InputExtensions.this.insertLink(userInputValue);
            }
        });
        inputAlert.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = inputAlert.create();
        alertDialog.show();
    }

    public void appendText(Editable text) {
    }

    public void insertLink(String uri) {
        EditorType editorType = this.editorCore.getControlType(this.editorCore.getActiveView());
        EditText editText = (EditText)this.editorCore.getActiveView();
        if (editorType == EditorType.INPUT || editorType == EditorType.UL_LI) {
            String text = Html.toHtml((Spanned)editText.getText());
            if (TextUtils.isEmpty((CharSequence)text)) {
                text = "<p dir=\"ltr\"></p>";
            }
            text = this.trimLineEnding(text);
            Document _doc = Jsoup.parse((String)text);
            Elements x = _doc.select("p");
            String existing = x.get(0).html();
            x.get(0).html(existing + " <a href='" + uri + "'>" + uri + "</a>");
            Spanned toTrim = Html.fromHtml((String)x.toString());
            CharSequence trimmed = this.noTrailingwhiteLines((CharSequence)toTrim);
            editText.setText(trimmed);
            editText.setSelection(editText.getText().length());
        }
    }

    public CharSequence noTrailingwhiteLines(CharSequence text) {
        if (text.length() == 0) {
            return text;
        }
        while (text.charAt(text.length() - 1) == '\n') {
            text = text.subSequence(0, text.length() - 1);
        }
        return text;
    }

    public CharSequence noLeadingwhiteLines(CharSequence text) {
        if (text.length() == 0) {
            return text;
        }
        while (text.charAt(0) == '\n') {
            text = text.subSequence(1, text.length());
        }
        return text;
    }

    public boolean isEditTextEmpty(EditText editText) {
        return editText.getText().toString().trim().length() == 0;
    }

    private String trimLineEnding(String s) {
        if (s.charAt(s.length() - 1) == '\n') {
            String formatted = s.toString().substring(0, s.length() - 1);
            return formatted;
        }
        return s;
    }

    public Typeface getTypeface(int mode, int style2) {
        if (mode == 0 && this.headingTypeface == null) {
            return Typeface.create((String)this.getFontFace(), (int)style2);
        }
        if (mode == 1 && this.contentTypeface == null) {
            return Typeface.create((String)this.getFontFace(), (int)style2);
        }
        if (mode == 0 && !this.headingTypeface.containsKey(style2)) {
            throw new IllegalArgumentException("the provided fonts for heading is missing the varient for this style. Please checkout the documentation on adding custom fonts.");
        }
        if (mode == 1 && !this.headingTypeface.containsKey(style2)) {
            throw new IllegalArgumentException("the provided fonts for content is missing the varient for this style. Please checkout the documentation on adding custom fonts.");
        }
        if (mode == 0) {
            return FontCache.get(this.headingTypeface.get(style2), this.editorCore.getContext());
        }
        return FontCache.get(this.contentTypeface.get(style2), this.editorCore.getContext());
    }

    public void setFocus(CustomEditText view) {
        if (this.editorCore.isStateFresh() && !this.editorCore.getAutoFucus()) {
            this.editorCore.setStateFresh(false);
            return;
        }
        view.requestFocus();
        InputMethodManager mgr = (InputMethodManager)this.editorCore.getActivity().getSystemService("input_method");
        mgr.showSoftInput((View)view, 1);
        view.setSelection(view.getText().length());
        this.editorCore.setActiveView((View)view);
    }

    public CustomEditText getEditTextPrevious(int startIndex) {
        CustomEditText customEditText = null;
        for (int i = 0; i < startIndex; ++i) {
            View view = this.editorCore.getParentView().getChildAt(i);
            EditorType editorType = this.editorCore.getControlType(view);
            if (editorType == EditorType.hr || editorType == EditorType.img || editorType == EditorType.map) continue;
            if (editorType == EditorType.INPUT) {
                customEditText = (CustomEditText)view;
                continue;
            }
            if (editorType != EditorType.ol && editorType != EditorType.ul) continue;
            this.componentsWrapper.getListItemExtensions().setFocusToList(view, 0);
            this.editorCore.setActiveView(view);
        }
        return customEditText;
    }

    public void setFocusToPrevious(int startIndex) {
        for (int i = startIndex; i > 0; --i) {
            View view = this.editorCore.getParentView().getChildAt(i);
            EditorType editorType = this.editorCore.getControlType(view);
            if (editorType == EditorType.hr || editorType == EditorType.img || editorType == EditorType.map) continue;
            if (editorType == EditorType.INPUT) {
                this.setFocus((CustomEditText)view);
                break;
            }
            if (editorType != EditorType.ol && editorType != EditorType.ul) continue;
            this.componentsWrapper.getListItemExtensions().setFocusToList(view, 0);
            this.editorCore.setActiveView(view);
        }
    }

    public boolean isInputTextAtPosition(int position) {
        return this.editorCore.getControlType(this.editorCore.getParentView().getChildAt(position)) == EditorType.INPUT;
    }

    public void updateTextColor(String color, TextView editText) {
        try {
            Pattern c;
            Matcher m;
            if (color.contains("rgb") && (m = (c = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)")).matcher(color)).matches()) {
                int r = Integer.parseInt(m.group(1));
                int g = Integer.parseInt(m.group(2));
                int b = Integer.parseInt(m.group(3));
                color = String.format(Locale.getDefault(), "#%02X%02X%02X", r, g, b);
            }
            if (editText == null) {
                editText = (EditText)this.editorCore.getActiveView();
            }
            EditorControl tag = this.editorCore.getControlTag((View)editText);
            if (tag.textSettings == null) {
                tag.textSettings = new TextSettings(color);
            } else {
                tag.textSettings.setTextColor(color);
            }
            editText.setTag((Object)tag);
            editText.setTextColor(Color.parseColor((String)color));
        }
        catch (Exception ex) {
            Log.e((String)"EDITOR", (String)ex.getMessage());
        }
    }

    public void applyStyles(TextView editText, Element element) {
        Map<String, String> styles = this.componentsWrapper.getHtmlExtensions().getStyleMap(element);
        if (styles.containsKey("color")) {
            this.updateTextColor(styles.get("color"), editText);
        }
    }

    public String getInputHtml(Node item) {
        boolean isParagraph = true;
        String tmpl = this.componentsWrapper.getHtmlExtensions().getTemplateHtml(item.type);
        String trimmed = Jsoup.parse((String)item.content.get(0)).body().select("p").html();
        HashMap<Enum, String> styles = new HashMap<Enum, String>();
        if (item.contentStyles.size() > 0) {
            for (EditorTextStyle style2 : item.contentStyles) {
                switch (style2) {
                    case BOLD: {
                        tmpl = tmpl.replace("{{$content}}", "<b>{{$content}}</b>");
                        break;
                    }
                    case BOLDITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<b><i>{{$content}}</i></b>");
                        break;
                    }
                    case ITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<i>{{$content}}</i>");
                        break;
                    }
                    case INDENT: {
                        styles.put(style2, "margin-left:25px");
                        break;
                    }
                    case OUTDENT: {
                        styles.put(style2, "margin-left:0");
                        break;
                    }
                    case H1: {
                        tmpl = tmpl.replace("{{$tag}}", "h1");
                        isParagraph = false;
                        break;
                    }
                    case H2: {
                        tmpl = tmpl.replace("{{$tag}}", "h2");
                        isParagraph = false;
                        break;
                    }
                    case H3: {
                        tmpl = tmpl.replace("{{$tag}}", "h3");
                        isParagraph = false;
                        break;
                    }
                    case NORMAL: {
                        tmpl = tmpl.replace("{{$tag}}", "p");
                        isParagraph = true;
                    }
                }
            }
        }
        styles.put(TextSetting.TEXT_COLOR, "color:" + item.textSettings.getTextColor());
        if (item.type == EditorType.OL_LI || item.type == EditorType.UL_LI) {
            tmpl = tmpl.replace("{{$tag}}", "span");
        } else if (isParagraph) {
            tmpl = tmpl.replace("{{$tag}}", "p");
        }
        tmpl = tmpl.replace("{{$content}}", trimmed);
        tmpl = tmpl.replace(" {{$style}}", this.createStyleTag(styles));
        return tmpl;
    }

    private String createStyleTag(Map<Enum, String> styles) {
        String tmpl = " style=\"{{builder}}\"";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Enum, String> style2 : styles.entrySet()) {
            builder.append(style2.getValue()).append(";");
        }
        tmpl = tmpl.replace("{{builder}}", builder);
        return tmpl;
    }

    public void applyTextSettings(Node node, TextView view) {
        if (node.contentStyles != null) {
            for (EditorTextStyle style2 : node.contentStyles) {
                this.UpdateTextStyle(style2, view);
            }
            if (!TextUtils.isEmpty((CharSequence)node.textSettings.getTextColor())) {
                this.updateTextColor(node.textSettings.getTextColor(), view);
            }
        }
    }

    public void RenderHeader(HtmlTag tag, Element element) {
        int count = this.editorCore.getParentView().getChildCount();
        String text = this.componentsWrapper.getHtmlExtensions().getHtmlSpan(element);
        TextView editText = this.insertEditText(count, null, text);
        EditorTextStyle style2 = tag == HtmlTag.h1 ? EditorTextStyle.H1 : (tag == HtmlTag.h2 ? EditorTextStyle.H2 : EditorTextStyle.H3);
        this.UpdateTextStyle(style2, editText);
        this.applyStyles(editText, element);
    }

    public void removeFocus(CustomEditText editText) {
        editText.clearFocus();
        InputMethodManager imm = (InputMethodManager)this.editorCore.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        this.editorCore.getParentView().removeView((View)editText);
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }
}

