/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorComponent;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.HtmlTag;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.RenderType;
import com.github.irshulx.models.TextSettings;
import com.squareup.picasso.Picasso;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.jsoup.nodes.Element;

public class ImageExtensions
extends EditorComponent {
    private EditorCore editorCore;
    private int editorImageLayout = R.layout.tmpl_image_view;

    @Override
    public Node getContent(View view) {
        Node node = this.getNodeInstance(view);
        EditorControl imgTag = (EditorControl)view.getTag();
        if (!TextUtils.isEmpty((CharSequence)imgTag.path)) {
            node.content.add(imgTag.path);
            EditText textView = (EditText)view.findViewById(R.id.desc);
            Node subTitleNode = this.getNodeInstance((View)textView);
            EditorControl descTag = (EditorControl)textView.getTag();
            subTitleNode.contentStyles = descTag.editorTextStyles;
            subTitleNode.textSettings = descTag.textSettings;
            Editable desc = textView.getText();
            subTitleNode.content.add(Html.toHtml((Spanned)desc));
            node.childs = new ArrayList();
            node.childs.add(subTitleNode);
        }
        return node;
    }

    @Override
    public String getContentAsHTML(Node node, EditorContent content) {
        String subHtml = this.componentsWrapper.getInputExtensions().getInputHtml(node.childs.get(0));
        String html = this.componentsWrapper.getHtmlExtensions().getTemplateHtml(node.type);
        html = html.replace("{{$url}}", node.content.get(0));
        html = html.replace("{{$img-sub}}", subHtml);
        return html;
    }

    @Override
    public void renderEditorFromState(Node node, EditorContent content) {
        String path = node.content.get(0);
        if (this.editorCore.getRenderType() == RenderType.Renderer) {
            this.loadImage(path, node.childs.get(0));
        } else {
            View layout2 = this.insertImage(null, path, this.editorCore.getChildCount(), node.childs.get((int)0).content.get(0), false);
            this.componentsWrapper.getInputExtensions().applyTextSettings(node.childs.get(0), (TextView)layout2.findViewById(R.id.desc));
        }
    }

    @Override
    public Node buildNodeFromHTML(Element element) {
        HtmlTag tag = HtmlTag.valueOf(element.tagName().toLowerCase());
        if (tag == HtmlTag.div) {
            String dataTag = element.attr("data-tag");
            if (dataTag.equals("img")) {
                Element img = element.child(0);
                Element descTag = element.child(1);
                String src = img.attr("src");
                this.loadImage(src, descTag);
            }
        } else {
            String src = element.attr("src");
            Element descTag = element.child(1);
            this.loadImage(src, descTag);
        }
        return null;
    }

    @Override
    public void init(ComponentsWrapper componentsWrapper) {
        this.componentsWrapper = componentsWrapper;
    }

    public ImageExtensions(EditorCore editorCore) {
        super(editorCore);
        this.editorCore = editorCore;
    }

    public void setEditorImageLayout(int drawable2) {
        this.editorImageLayout = drawable2;
    }

    public void openImageGallery() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        ((Activity)this.editorCore.getContext()).startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select an image"), this.editorCore.PICK_IMAGE_REQUEST);
    }

    public View insertImage(Bitmap image, String url, int index, String subTitle, boolean appendTextline) {
        boolean hasUploaded = false;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            hasUploaded = true;
        }
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        TextView lblStatus = (TextView)childLayout.findViewById(R.id.lblStatus);
        final CustomEditText desc = (CustomEditText)childLayout.findViewById(R.id.desc);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Picasso.with((Context)this.editorCore.getContext()).load(url).into(imageView);
        } else {
            imageView.setImageBitmap(image);
        }
        String uuid = this.generateUUID();
        if (index == -1) {
            index = this.editorCore.determineIndex(EditorType.img);
        }
        this.showNextInputHint(index);
        this.editorCore.getParentView().addView(childLayout, index);
        childLayout.setTag((Object)this.createImageTag(hasUploaded ? url : uuid));
        desc.setTag(this.createSubTitleTag());
        desc.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    desc.clearFocus();
                } else {
                    ImageExtensions.this.editorCore.setActiveView((View)desc);
                }
            }
        });
        if (this.editorCore.isLastRow(childLayout) && appendTextline) {
            this.componentsWrapper.getInputExtensions().insertEditText(index + 1, null, null);
        }
        if (!TextUtils.isEmpty((CharSequence)subTitle)) {
            this.componentsWrapper.getInputExtensions().setText((TextView)desc, subTitle);
        }
        if (this.editorCore.getRenderType() == RenderType.Editor) {
            this.BindEvents(childLayout);
            if (!hasUploaded) {
                lblStatus.setVisibility(0);
                childLayout.findViewById(R.id.progress).setVisibility(0);
                this.editorCore.getEditorListener().onUpload(image, uuid);
            }
        } else {
            desc.setEnabled(false);
            lblStatus.setVisibility(8);
        }
        return childLayout;
    }

    private void showNextInputHint(int index) {
        View view = this.editorCore.getParentView().getChildAt(index);
        EditorType type = this.editorCore.getControlType(view);
        if (type != EditorType.INPUT) {
            return;
        }
        TextView tv = (TextView)view;
        tv.setHint((CharSequence)this.editorCore.getPlaceHolder());
        Linkify.addLinks((TextView)tv, (int)15);
    }

    private void hideInputHint(int index) {
        View prevView;
        EditorType prevType;
        View view = this.editorCore.getParentView().getChildAt(index);
        EditorType type = this.editorCore.getControlType(view);
        if (type != EditorType.INPUT) {
            return;
        }
        String hint = this.editorCore.getPlaceHolder();
        if (index > 0 && (prevType = this.editorCore.getControlType(prevView = this.editorCore.getParentView().getChildAt(index - 1))) == EditorType.INPUT) {
            hint = null;
        }
        TextView tv = (TextView)view;
        tv.setHint((CharSequence)hint);
    }

    public String generateUUID() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String sdt = df.format(new Date(System.currentTimeMillis()));
        UUID x = UUID.randomUUID();
        String[] y = x.toString().split("-");
        return y[y.length - 1] + sdt;
    }

    public EditorControl createSubTitleTag() {
        EditorControl subTag = this.editorCore.createTag(EditorType.IMG_SUB);
        subTag.textSettings = new TextSettings("#5E5E5E");
        return subTag;
    }

    public EditorControl createImageTag(String path) {
        EditorControl control = this.editorCore.createTag(EditorType.img);
        control.path = path;
        return control;
    }

    public void loadImage(String _path, Node node) {
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        CustomEditText text = (CustomEditText)childLayout.findViewById(R.id.desc);
        childLayout.setTag((Object)this.createImageTag(_path));
        text.setTag(this.createSubTitleTag());
        String desc = node.content.get(0);
        if (TextUtils.isEmpty((CharSequence)desc)) {
            text.setVisibility(8);
        } else {
            this.componentsWrapper.getInputExtensions().setText((TextView)text, desc);
            text.setEnabled(false);
            this.componentsWrapper.getInputExtensions().applyTextSettings(node, (TextView)text);
        }
        Picasso.with((Context)this.editorCore.getContext()).load(_path).into(imageView);
        this.editorCore.getParentView().addView(childLayout);
    }

    public void loadImage(String _path, Element node) {
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.editorImageLayout, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        CustomEditText text = (CustomEditText)childLayout.findViewById(R.id.desc);
        childLayout.setTag((Object)this.createImageTag(_path));
        text.setTag(this.createSubTitleTag());
        String desc = node.html();
        if (TextUtils.isEmpty((CharSequence)desc)) {
            text.setVisibility(8);
        } else {
            this.componentsWrapper.getInputExtensions().setText((TextView)text, desc);
            text.setEnabled(false);
        }
        Picasso.with((Context)this.editorCore.getContext()).load(_path).into(imageView);
        this.editorCore.getParentView().addView(childLayout);
        this.componentsWrapper.getInputExtensions().applyStyles((TextView)text, node);
    }

    public View findImageById(String imageId) {
        for (int i = 0; i < this.editorCore.getParentChildCount(); ++i) {
            View view = this.editorCore.getParentView().getChildAt(i);
            EditorControl control = this.editorCore.getControlTag(view);
            if (TextUtils.isEmpty((CharSequence)control.path) || !control.path.equals(imageId)) continue;
            return view;
        }
        return null;
    }

    public void onPostUpload(String url, String imageId) {
        View view = this.findImageById(imageId);
        final TextView lblStatus = (TextView)view.findViewById(R.id.lblStatus);
        lblStatus.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)url) ? "Upload complete" : "Upload failed"));
        if (!TextUtils.isEmpty((CharSequence)url)) {
            EditorControl control = this.editorCore.createTag(EditorType.img);
            control.path = url;
            view.setTag((Object)control);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    ((Activity)ImageExtensions.this.editorCore.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            lblStatus.setVisibility(8);
                        }
                    });
                }
            };
            new Timer().schedule(timerTask, 3000L);
        }
        view.findViewById(R.id.progress).setVisibility(8);
    }

    private void BindEvents(final View layout2) {
        ImageView imageView = (ImageView)layout2.findViewById(R.id.imageView);
        final View btn_remove = layout2.findViewById(R.id.btn_remove);
        btn_remove.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = ImageExtensions.this.editorCore.getParentView().indexOfChild(layout2);
                ImageExtensions.this.editorCore.getParentView().removeView(layout2);
                ImageExtensions.this.hideInputHint(index);
                ImageExtensions.this.componentsWrapper.getInputExtensions().setFocusToPrevious(index);
            }
        });
        layout2.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (event.getAction() == 1) {
                    int paddingTop = view.getPaddingTop();
                    int paddingBottom = view.getPaddingBottom();
                    int height = view.getHeight();
                    if (event.getY() < (float)paddingTop) {
                        ImageExtensions.this.editorCore.___onViewTouched(0, ImageExtensions.this.editorCore.getParentView().indexOfChild(layout2));
                    } else if (event.getY() > (float)(height - paddingBottom)) {
                        ImageExtensions.this.editorCore.___onViewTouched(1, ImageExtensions.this.editorCore.getParentView().indexOfChild(layout2));
                    }
                    return false;
                }
                return true;
            }
        });
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn_remove.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn_remove.setVisibility(hasFocus ? 0 : 8);
            }
        });
    }
}

