/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.util.Linkify;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.RenderType;
import com.github.irshulx.models.TextSettings;
import org.jsoup.nodes.Element;

public class ListItemExtensions {
    EditorCore editorCore;
    public static final int POSITION_START = 0;
    public static final int POSITION_END = 1;
    private int listItemTemplate = R.layout.tmpl_list_item;

    public ListItemExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void setListItemTemplate(int drawable2) {
        this.listItemTemplate = drawable2;
    }

    public TableLayout insertList(int Index, boolean isOrdered, String text) {
        TableLayout table = this.CreateTable();
        this.editorCore.getParentView().addView((View)table, Index);
        table.setTag((Object)this.editorCore.createTag(isOrdered ? EditorType.ol : EditorType.ul));
        this.AddListItem(table, isOrdered, text);
        return table;
    }

    public TableLayout CreateTable() {
        TableLayout table = new TableLayout(this.editorCore.getContext());
        table.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        table.setPadding(30, 10, 10, 10);
        return table;
    }

    public View AddListItem(TableLayout layout2, boolean isOrdered, String text) {
        View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.listItemTemplate, null);
        final CustomEditText editText = (CustomEditText)childLayout.findViewById(R.id.txtText);
        TextView _order = (TextView)childLayout.findViewById(R.id.lblOrder);
        _order.setTypeface(Typeface.create((String)this.editorCore.getInputExtensions().getFontFace(), (int)1));
        editText.setTypeface(Typeface.create((String)this.editorCore.getInputExtensions().getFontFace(), (int)0));
        if (isOrdered) {
            int count = layout2.getChildCount();
            _order.setText((CharSequence)(String.valueOf(count + 1) + "."));
        }
        if (this.editorCore.getRenderType() == RenderType.Editor) {
            editText.setTextSize(2, this.editorCore.getInputExtensions().getNormalTextSize());
            editText.setTextColor(Color.parseColor((String)this.editorCore.getInputExtensions().getDefaultTextColor()));
            EditorControl tag = this.editorCore.createTag(isOrdered ? EditorType.OL_LI : EditorType.UL_LI);
            tag.textSettings = new TextSettings(this.editorCore.getInputExtensions().getDefaultTextColor());
            editText.setTag(tag);
            childLayout.setTag((Object)tag);
            editText.setTypeface(this.editorCore.getInputExtensions().getTypeface(1, 0));
            this.editorCore.setActiveView((View)editText);
            this.editorCore.getInputExtensions().setText((TextView)editText, text);
            editText.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListItemExtensions.this.editorCore.setActiveView(v);
                }
            });
            editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        ListItemExtensions.this.editorCore.setActiveView(v);
                    }
                }
            });
            editText.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    return ListItemExtensions.this.editorCore.onKey(v, keyCode, event, editText);
                }
            });
            editText.addTextChangedListener(new TextWatcher(){

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void afterTextChanged(Editable s) {
                    String text = Html.toHtml((Spanned)editText.getText());
                    if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                        text = text.replaceAll("<br>", "");
                        TableRow _row = (TableRow)editText.getParent();
                        TableLayout _table = (TableLayout)_row.getParent();
                        EditorType type = ListItemExtensions.this.editorCore.getControlType((View)_table);
                        if (s.length() == 0 || s.toString().equals("\n")) {
                            int index = ListItemExtensions.this.editorCore.getParentView().indexOfChild((View)_table);
                            _table.removeView((View)_row);
                            ListItemExtensions.this.editorCore.getInputExtensions().insertEditText(index + 1, "", "");
                        } else {
                            Spanned __ = Html.fromHtml((String)text);
                            CharSequence toReplace = ListItemExtensions.this.editorCore.getInputExtensions().noTrailingwhiteLines((CharSequence)__);
                            if (toReplace.length() > 0) {
                                editText.setText(toReplace);
                            } else {
                                editText.getText().clear();
                            }
                            int index = _table.indexOfChild((View)_row);
                            ListItemExtensions.this.AddListItem(_table, type == EditorType.ol, "");
                        }
                    }
                }
            });
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    editText.requestFocus();
                    InputMethodManager mgr = (InputMethodManager)ListItemExtensions.this.editorCore.getActivity().getSystemService("input_method");
                    mgr.showSoftInput((View)editText, 1);
                    editText.setSelection(editText.getText().length());
                }
            }, 0L);
        } else {
            TextView textView = (TextView)childLayout.findViewById(R.id.lblText);
            textView.setTypeface(this.editorCore.getInputExtensions().getTypeface(1, 0));
            if (!TextUtils.isEmpty((CharSequence)text)) {
                this.editorCore.getInputExtensions().setText(textView, text);
            }
            textView.setTextSize(2, (float)this.editorCore.getInputExtensions().getNormalTextSize());
            textView.setVisibility(0);
            Linkify.addLinks((TextView)textView, (int)15);
            editText.setVisibility(8);
        }
        layout2.addView(childLayout);
        return childLayout;
    }

    public void ConvertListToNormalText(TableLayout _table, int startIndex) {
        int tableChildCount = _table.getChildCount();
        for (int i = startIndex; i < tableChildCount; --tableChildCount, ++i) {
            View _childRow = _table.getChildAt(i);
            _table.removeView(_childRow);
            String text = this.getTextFromListItem(_childRow);
            int Index = this.editorCore.getParentView().indexOfChild((View)_table);
            this.editorCore.getInputExtensions().insertEditText(Index + 1, "", text);
            --i;
        }
        if (_table.getChildCount() == 0) {
            this.editorCore.getParentView().removeView((View)_table);
        }
    }

    public void convertListToOrdered(TableLayout _table) {
        EditorControl type = this.editorCore.createTag(EditorType.ol);
        _table.setTag((Object)type);
        for (int i = 0; i < _table.getChildCount(); ++i) {
            View _childRow = _table.getChildAt(i);
            CustomEditText editText = (CustomEditText)_childRow.findViewById(R.id.txtText);
            editText.setTag(this.editorCore.createTag(EditorType.OL_LI));
            _childRow.setTag((Object)this.editorCore.createTag(EditorType.OL_LI));
            TextView _bullet = (TextView)_childRow.findViewById(R.id.lblOrder);
            _bullet.setText((CharSequence)(String.valueOf(i + 1) + "."));
        }
    }

    public void convertListToUnordered(TableLayout _table) {
        EditorControl type = this.editorCore.createTag(EditorType.ul);
        _table.setTag((Object)type);
        for (int i = 0; i < _table.getChildCount(); ++i) {
            View _childRow = _table.getChildAt(i);
            CustomEditText _EditText = (CustomEditText)_childRow.findViewById(R.id.txtText);
            _EditText.setTag(this.editorCore.createTag(EditorType.UL_LI));
            _childRow.setTag((Object)this.editorCore.createTag(EditorType.UL_LI));
            TextView _bullet = (TextView)_childRow.findViewById(R.id.lblOrder);
            _bullet.setText((CharSequence)"\u2022");
        }
    }

    public String getTextFromListItem(View row) {
        CustomEditText _text = (CustomEditText)row.findViewById(R.id.txtText);
        return _text.getText().toString();
    }

    public void insertlist(boolean isOrdered) {
        View activeView = this.editorCore.getActiveView();
        EditorType currentFocus = this.editorCore.getControlType(activeView);
        if (currentFocus == EditorType.UL_LI && !isOrdered) {
            TableRow _row = (TableRow)activeView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToNormalText(_table, _table.indexOfChild((View)_row));
        } else if (currentFocus == EditorType.UL_LI && isOrdered) {
            TableRow _row = (TableRow)activeView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.convertListToOrdered(_table);
        } else if (currentFocus == EditorType.OL_LI && isOrdered) {
            TableRow _row = (TableRow)activeView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.ConvertListToNormalText(_table, _table.indexOfChild((View)_row));
        } else if (currentFocus == EditorType.OL_LI && !isOrdered) {
            TableRow _row = (TableRow)activeView.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            this.convertListToUnordered(_table);
        } else if (isOrdered) {
            int index_of_activeView = this.editorCore.getParentView().indexOfChild(this.editorCore.getActiveView());
            int Index = this.editorCore.determineIndex(EditorType.OL_LI);
            View view = this.editorCore.getParentView().getChildAt(Index);
            if (view != null) {
                EditorType type = this.editorCore.getControlType(view);
                if (type == EditorType.INPUT) {
                    String text = ((CustomEditText)view).getText().toString();
                    this.editorCore.getParentView().removeView(view);
                    if (Index == 0) {
                        this.insertList(Index, isOrdered, text);
                    } else if (this.editorCore.getControlType(this.editorCore.getParentView().getChildAt(index_of_activeView - 1)) == EditorType.ol) {
                        TableLayout _table = (TableLayout)this.editorCore.getParentView().getChildAt(index_of_activeView - 1);
                        this.AddListItem(_table, isOrdered, text);
                    } else {
                        this.insertList(Index, isOrdered, text);
                    }
                } else {
                    this.insertList(Index, isOrdered, "");
                }
            } else {
                this.insertList(Index, isOrdered, "");
            }
        } else {
            int Index = this.editorCore.determineIndex(EditorType.UL_LI);
            View view = this.editorCore.getParentView().getChildAt(Index);
            if (view != null) {
                EditorType type = this.editorCore.getControlType(view);
                if (type == EditorType.INPUT) {
                    String text = ((EditText)view).getText().toString();
                    this.editorCore.getParentView().removeView(view);
                    this.insertList(Index, false, text);
                } else {
                    this.insertList(Index, false, "");
                }
            } else {
                this.insertList(Index, false, "");
            }
        }
    }

    private void rearrangeColumns(TableLayout _table) {
        for (int i = 0; i < _table.getChildCount(); ++i) {
            TableRow tableRow = (TableRow)_table.getChildAt(i);
            TextView _bullet = (TextView)tableRow.findViewById(R.id.lblOrder);
            _bullet.setText((CharSequence)(String.valueOf(i + 1) + "."));
        }
    }

    public void validateAndRemoveLisNode(View view, EditorControl contentType) {
        TableRow _row = (TableRow)view.getParent();
        TableLayout _table = (TableLayout)_row.getParent();
        int indexOnList = _table.indexOfChild((View)_row);
        _table.removeView((View)_row);
        if (indexOnList > 0) {
            TableRow focusrow = (TableRow)_table.getChildAt(indexOnList - 1);
            EditText text = (EditText)focusrow.findViewById(R.id.txtText);
            if (contentType.Type == EditorType.OL_LI) {
                this.rearrangeColumns(_table);
            }
            if (text.requestFocus()) {
                text.setSelection(text.getText().length());
            }
        } else {
            this.editorCore.removeParent((View)_table);
        }
    }

    public void setFocusToList(View view, int position) {
        EditText editText;
        TableRow tableRow;
        TableLayout tableLayout = (TableLayout)view;
        int count = tableLayout.getChildCount();
        if (tableLayout.getChildCount() > 0 && (tableRow = (TableRow)tableLayout.getChildAt(position == 0 ? 0 : count - 1)) != null && (editText = (EditText)tableRow.findViewById(R.id.txtText)).requestFocus()) {
            editText.setSelection(editText.getText().length());
        }
    }

    public int getIndexOnEditorByEditText(CustomEditText customEditText) {
        TableRow tableRow = (TableRow)customEditText.getParent();
        TableLayout tableLayout = (TableLayout)tableRow.getParent();
        int indexOnTable = tableLayout.indexOfChild((View)tableRow);
        return indexOnTable;
    }

    public CustomEditText setFocusToSpecific(CustomEditText customEditText) {
        TableRow prevRow;
        TableRow tableRow = (TableRow)customEditText.getParent();
        TableLayout tableLayout = (TableLayout)tableRow.getParent();
        int indexOnTable = tableLayout.indexOfChild((View)tableRow);
        if (indexOnTable == 0) {
            // empty if block
        }
        if ((prevRow = (TableRow)tableLayout.getChildAt(indexOnTable - 1)) != null) {
            CustomEditText editText = (CustomEditText)tableRow.findViewById(R.id.txtText);
            if (editText.requestFocus()) {
                editText.setSelection(editText.getText().length());
            }
            return editText;
        }
        return null;
    }

    public void applyStyles(View view, Element element) {
        TextView textView = this.editorCore.getRenderType() == RenderType.Editor ? (TextView)view.findViewById(R.id.txtText) : (TextView)view.findViewById(R.id.lblText);
        this.editorCore.getInputExtensions().applyStyles(textView, element);
    }
}

