/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.view.View;
import android.widget.TableLayout;
import android.widget.TextView;
import com.github.irshulx.EditorCore;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.HtmlTag;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.TextSetting;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class HTMLExtensions {
    EditorCore editorCore;

    public HTMLExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void parseHtml(String htmlString) {
        Document doc = Jsoup.parse((String)htmlString);
        for (Element element : doc.body().children()) {
            if (!HTMLExtensions.matchesTag(element.tagName().toLowerCase())) continue;
            this.buildNode(element);
        }
    }

    private void buildNode(Element element) {
        HtmlTag tag = HtmlTag.valueOf(element.tagName().toLowerCase());
        int count = this.editorCore.getParentView().getChildCount();
        String x = element.html().replaceAll("\\s+", "");
        if ("<br>".equals(element.html().replaceAll("\\s+", "")) || "<br/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.editorCore.getInputExtensions().insertEditText(count, null, null);
            return;
        }
        if ("<hr>".equals(element.html().replaceAll("\\s+", "")) || "<hr/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.editorCore.getDividerExtensions().insertDivider();
            return;
        }
        switch (tag) {
            case h1: 
            case h2: 
            case h3: {
                this.RenderHeader(tag, element);
                break;
            }
            case p: {
                String text = element.html();
                TextView textView = this.editorCore.getInputExtensions().insertEditText(count, null, text);
                this.editorCore.getInputExtensions().applyStyles(textView, element);
                break;
            }
            case ul: 
            case ol: {
                this.RenderList(tag == HtmlTag.ol, element);
                break;
            }
            case img: {
                this.RenderImageFromHtml(element);
                break;
            }
            case div: {
                this.renderDiv(element);
            }
        }
    }

    private void renderDiv(Element element) {
        String tag = element.attr("data-tag");
        if (tag.equals("img")) {
            this.RenderImage(element);
        }
    }

    private void RenderImage(Element element) {
        Element img = element.child(0);
        Element descTag = element.child(1);
        String src = img.attr("src");
        String desc = descTag.html();
        int Index = this.editorCore.getParentChildCount();
        this.editorCore.getImageExtensions().executeDownloadImageTask(src, Index, desc);
    }

    private void RenderImageFromHtml(Element element) {
        String src = element.attr("src");
        String desc = element.html();
        int Index = this.editorCore.getParentChildCount();
        this.editorCore.getImageExtensions().executeDownloadImageTask(src, Index, desc);
    }

    private void RenderList(boolean isOrdered, Element element) {
        if (element.children().size() > 0) {
            Element li = element.child(0);
            String text = this.getHtmlSpan(li);
            TableLayout layout2 = this.editorCore.getListItemExtensions().insertList(this.editorCore.getParentChildCount(), isOrdered, text);
            for (int i = 1; i < element.children().size(); ++i) {
                li = element.child(i);
                text = this.getHtmlSpan(li);
                View view = this.editorCore.getListItemExtensions().AddListItem(layout2, isOrdered, text);
                this.editorCore.getListItemExtensions().applyStyles(view, li);
            }
        }
    }

    private void RenderHeader(HtmlTag tag, Element element) {
        int count = this.editorCore.getParentView().getChildCount();
        String text = this.getHtmlSpan(element);
        TextView editText = this.editorCore.getInputExtensions().insertEditText(count, null, text);
        EditorTextStyle style2 = tag == HtmlTag.h1 ? EditorTextStyle.H1 : (tag == HtmlTag.h2 ? EditorTextStyle.H2 : EditorTextStyle.H3);
        this.editorCore.getInputExtensions().UpdateTextStyle(style2, editText);
        this.editorCore.getInputExtensions().applyStyles(editText, element);
    }

    public Map<String, String> getStyleMap(Element element) {
        HashMap<String, String> keymaps = new HashMap<String, String>();
        if (!element.hasAttr("style")) {
            return keymaps;
        }
        String styleStr = element.attr("style");
        String[] keys = styleStr.split(":");
        if (keys.length > 1) {
            for (int i = 0; i < keys.length; ++i) {
                String[] split;
                if (i % 2 != 0) {
                    split = keys[i].split(";");
                    if (split.length == 1) break;
                    keymaps.put(split[1].trim(), keys[i + 1].split(";")[0].trim());
                    continue;
                }
                split = keys[i].split(";");
                if (i + 1 == keys.length) break;
                keymaps.put(keys[i].split(";")[split.length - 1].trim(), keys[i + 1].split(";")[0].trim());
            }
        }
        return keymaps;
    }

    private String getHtmlSpan(Element element) {
        Element el = new Element(Tag.valueOf((String)"span"), "");
        el.attributes().put("style", element.attr("style"));
        el.html(element.html());
        return el.toString();
    }

    private boolean hasChildren(Element element) {
        return element.getAllElements().size() > 0;
    }

    private static boolean matchesTag(String test) {
        for (HtmlTag tag : HtmlTag.values()) {
            if (!tag.name().equals(test)) continue;
            return true;
        }
        return false;
    }

    private String getTemplateHtml(EditorType child) {
        String template = null;
        switch (child) {
            case INPUT: {
                template = "<{{$tag}} data-tag=\"input\" {{$style}}>{{$content}}</{{$tag}}>";
                break;
            }
            case hr: {
                template = "<hr data-tag=\"hr\"/>";
                break;
            }
            case img: {
                template = "<div data-tag=\"img\"><img src=\"{{$content}}\" /><span class=\"editor-image-subtitle\">{{$desc}}</span></div>";
                break;
            }
            case map: {
                template = "<div data-tag=\"map\"><img src=\"{{$content}}\" /><span text-align:'center'>{{$desc}}</span></div>";
                break;
            }
            case ol: {
                template = "<ol data-tag=\"ol\">{{$content}}</ol>";
                break;
            }
            case ul: {
                template = "<ul data-tag=\"ul\">{{$content}}</ul>";
                break;
            }
            case OL_LI: 
            case UL_LI: {
                String dataTag = child == EditorType.OL_LI ? "data-tag=\"list-item-ol\"" : "data-tag=\"list-item-ul\"";
                template = "<li " + dataTag + "><{{$tag}} {{$style}}>{{$content}}</{{$tag}}></li>";
            }
        }
        return template;
    }

    private String createStyleTag(Map<Enum, String> styles) {
        String tmpl = " style=\"{{builder}}\"";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Enum, String> style2 : styles.entrySet()) {
            builder.append(style2.getValue()).append(";");
        }
        tmpl = tmpl.replace("{{builder}}", builder);
        return tmpl;
    }

    private String getInputHtml(Node item) {
        boolean isParagraph = true;
        String tmpl = this.getTemplateHtml(item.type);
        String trimmed = Jsoup.parse((String)item.content.get(0)).body().select("p").html();
        HashMap<Enum, String> styles = new HashMap<Enum, String>();
        if (item.contentStyles.size() > 0) {
            for (EditorTextStyle style2 : item.contentStyles) {
                switch (style2) {
                    case BOLD: {
                        tmpl = tmpl.replace("{{$content}}", "<b>{{$content}}</b>");
                        break;
                    }
                    case BOLDITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<b><i>{{$content}}</i></b>");
                        break;
                    }
                    case ITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<i>{{$content}}</i>");
                        break;
                    }
                    case INDENT: {
                        styles.put(style2, "margin-left:25px");
                        break;
                    }
                    case OUTDENT: {
                        styles.put(style2, "margin-left:0");
                        break;
                    }
                    case H1: {
                        tmpl = tmpl.replace("{{$tag}}", "h1");
                        isParagraph = false;
                        break;
                    }
                    case H2: {
                        tmpl = tmpl.replace("{{$tag}}", "h2");
                        isParagraph = false;
                        break;
                    }
                    case H3: {
                        tmpl = tmpl.replace("{{$tag}}", "h3");
                        isParagraph = false;
                        break;
                    }
                    case NORMAL: {
                        tmpl = tmpl.replace("{{$tag}}", "p");
                        isParagraph = true;
                    }
                }
            }
        }
        styles.put(TextSetting.TEXT_COLOR, "color:" + item.textSettings.getTextColor());
        if (item.type == EditorType.OL_LI || item.type == EditorType.UL_LI) {
            tmpl = tmpl.replace("{{$tag}}", "span");
        } else if (isParagraph) {
            tmpl = tmpl.replace("{{$tag}}", "p");
        }
        tmpl = tmpl.replace("{{$content}}", trimmed);
        tmpl = tmpl.replace(" {{$style}}", this.createStyleTag(styles));
        return tmpl;
    }

    public String getContentAsHTML() {
        StringBuilder htmlBlock = new StringBuilder();
        EditorContent content = this.editorCore.getContent();
        return this.getContentAsHTML(content);
    }

    public String getContentAsHTML(EditorContent content) {
        StringBuilder htmlBlock = new StringBuilder();
        for (Node item : content.nodes) {
            switch (item.type) {
                case INPUT: {
                    String html = this.getInputHtml(item);
                    htmlBlock.append(html);
                    break;
                }
                case img: {
                    htmlBlock.append(this.getTemplateHtml(item.type).replace("{{$content}}", item.content.get(0)).replace("{{$desc}}", item.content.get(1)));
                    break;
                }
                case hr: {
                    htmlBlock.append(this.getTemplateHtml(item.type));
                    break;
                }
                case map: {
                    htmlBlock.append(this.getTemplateHtml(item.type).replace("{{$content}}", this.editorCore.getMapExtensions().getCordsAsUri(item.content.get(0))).replace("{{$desc}}", item.content.get(1)));
                    break;
                }
                case ol: 
                case ul: {
                    htmlBlock.append(this.getListAsHtml(item));
                }
            }
        }
        return htmlBlock.toString();
    }

    public String getContentAsHTML(String editorContentAsSerialized) {
        EditorContent content = this.editorCore.getContentDeserialized(editorContentAsSerialized);
        return this.getContentAsHTML(content);
    }

    private String getListAsHtml(Node item) {
        int count = item.childs.size();
        String tmpl_parent = this.getTemplateHtml(item.type);
        StringBuilder childBlock = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String html = this.getInputHtml(item.childs.get(i));
            childBlock.append(html);
        }
        tmpl_parent = tmpl_parent.replace("{{$content}}", childBlock.toString());
        return tmpl_parent;
    }
}

