/*
 * Decompiled with CFR 0.152.
 */
package com.irshu.libs.Components;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.ImageView;
import com.irshu.editor.R;
import com.irshu.libs.BaseClass;
import com.irshu.libs.MapsActivity;
import com.irshu.libs.models.EditorControl;
import com.irshu.libs.models.EditorType;
import com.squareup.picasso.Picasso;

public class MapExtensions {
    private Context context;
    BaseClass base;
    private int mapExtensionTemplate = R.layout.editor_image_view;

    public MapExtensions(BaseClass baseClass, Context context) {
        this.base = baseClass;
        this.context = context;
    }

    public void setMapViewTemplate(int drawable2) {
        this.mapExtensionTemplate = drawable2;
    }

    public void insertMap(String cords, boolean insertEditText) {
        String[] x = cords.split(",");
        String lat = x[0];
        String lng = x[1];
        int[] size = this.base.getUtilitiles().GetScreenDimension();
        int width = size[0];
        StringBuilder builder = new StringBuilder();
        builder.append("http://maps.google.com/maps/api/staticmap?");
        builder.append("size=" + String.valueOf(width) + "x400&zoom=15&sensor=true&markers=" + lat + "," + lng);
        final View childLayout = ((Activity)this.context).getLayoutInflater().inflate(this.mapExtensionTemplate, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        Picasso.with((Context)this.context).load(builder.toString()).into(imageView);
        final View btn = childLayout.findViewById(R.id.btn_remove);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn.setVisibility(hasFocus ? 0 : 4);
            }
        });
        btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapExtensions.this.base.getParentView().removeView(childLayout);
            }
        });
        EditorControl control = this.base.CreateTag(EditorType.map);
        control.Cords = cords;
        childLayout.setTag((Object)control);
        int Index = this.base.determineIndex(EditorType.map);
        this.base.getParentView().addView(childLayout, Index);
        if (insertEditText && this.base.GetChildCount() == 2) {
            insertEditText = false;
        }
        if (insertEditText) {
            this.base.getInputExtensions().InsertEditText(Index + 1, null, null);
        }
    }

    public void loadMapActivity() {
        Intent intent = new Intent(this.context, MapsActivity.class);
        ((Activity)this.context).startActivityForResult(intent, this.base.MAP_MARKER_REQUEST);
    }
}

