/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.bytedeco.arpackng.global.arpack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.blas.Layout;
import smile.math.matrix.DMatrix;
import smile.math.matrix.FloatMatrix;
import smile.math.matrix.Matrix;
import smile.math.matrix.SMatrix;

public interface ARPACK {
    public static final Logger logger = LoggerFactory.getLogger(ARPACK.class);

    public static Matrix.EVD syev(DMatrix A, SymmOption which, int nev) {
        return ARPACK.syev(A, which, nev, Math.min(3 * nev, A.nrows()), 1.0E-6);
    }

    public static Matrix.EVD syev(DMatrix A, SymmOption which, int nev, int ncv, double tol) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        int n = A.nrows();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV parameter k: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        double[] workd = new double[3 * n];
        double[] workl = new double[ncv * (ncv + 8)];
        double[] resid = new double[n];
        double[] V = new double[n * ncv];
        int ldv = n;
        do {
            arpack.dsaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DSAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        double[] d = new double[ncv * 2];
        int[] select = new int[ncv];
        double sigma = 0.0;
        boolean rvec = true;
        arpack.dseupd_c((boolean)rvec, (byte[])howmny, (int[])select, (double[])d, (double[])V, (int)ldv, (double)sigma, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DSEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DSEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DSEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        d = Arrays.copyOfRange(d, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(d, Matrix.of(Layout.COL_MAJOR, n, nev, ldv, DoubleBuffer.wrap(V)));
        return eig.sort();
    }

    public static FloatMatrix.EVD syev(SMatrix A, SymmOption which, int nev) {
        return ARPACK.syev(A, which, nev, Math.min(3 * nev, A.nrows()), 1.0E-6f);
    }

    public static FloatMatrix.EVD syev(SMatrix A, SymmOption which, int nev, int ncv, float tol) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        int n = A.nrows();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = swhich.getBytes();
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        float[] workd = new float[3 * n];
        float[] workl = new float[ncv * (ncv + 8)];
        float[] resid = new float[n];
        float[] V = new float[n * ncv];
        int ldv = n;
        do {
            arpack.ssaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DSAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        float[] d = new float[ncv * 2];
        int[] select = new int[ncv];
        float sigma = 0.0f;
        boolean rvec = true;
        arpack.sseupd_c((boolean)rvec, (byte[])howmny, (int[])select, (float[])d, (float[])V, (int)ldv, (float)sigma, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DSEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DSEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DSEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        d = Arrays.copyOfRange(d, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        FloatMatrix.EVD eig = new FloatMatrix.EVD(d, FloatMatrix.of(Layout.COL_MAJOR, n, nev, ldv, FloatBuffer.wrap(V)));
        return eig.sort();
    }

    public static Matrix.EVD eigen(DMatrix A, AsymmOption which, int nev) {
        return ARPACK.eigen(A, which, nev, Math.min(3 * nev, A.nrows()), 1.0E-6);
    }

    public static Matrix.EVD eigen(DMatrix A, AsymmOption which, int nev, int ncv, double tol) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        int n = A.nrows();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[14];
        double[] workd = new double[3 * n];
        double[] workev = new double[3 * ncv];
        double[] workl = new double[3 * ncv * ncv + 6 * ncv];
        double[] resid = new double[n];
        double[] V = new double[n * ncv];
        int ldv = n;
        do {
            arpack.dnaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DNAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        double[] wr = new double[ncv * 2];
        double[] wi = new double[ncv * 2];
        int[] select = new int[ncv];
        double sigmar = 0.0;
        double sigmai = 0.0;
        boolean rvec = true;
        arpack.dneupd_c((boolean)rvec, (byte[])howmny, (int[])select, (double[])wr, (double[])wi, (double[])V, (int)ldv, (double)sigmar, (double)sigmai, (double[])workev, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (double)tol, (double[])resid, (int)ncv, (double[])V, (int)ldv, (int[])iparam, (int[])ipntr, (double[])workd, (double[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DNEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DNEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DNEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        wr = Arrays.copyOfRange(wr, 0, nev);
        wi = Arrays.copyOfRange(wi, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        Matrix.EVD eig = new Matrix.EVD(wr, wi, null, Matrix.of(Layout.COL_MAJOR, n, nev, ldv, DoubleBuffer.wrap(V)));
        return eig.sort();
    }

    public static FloatMatrix.EVD eigen(SMatrix A, AsymmOption which, int nev) {
        return ARPACK.eigen(A, which, nev, Math.min(3 * nev, A.nrows()), 1.0E-6f);
    }

    public static FloatMatrix.EVD eigen(SMatrix A, AsymmOption which, int nev, int ncv, float tol) {
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        int n = A.nrows();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[14];
        float[] workd = new float[3 * n];
        float[] workev = new float[3 * ncv];
        float[] workl = new float[3 * ncv * ncv + 6 * ncv];
        float[] resid = new float[n];
        float[] V = new float[n * ncv];
        int ldv = n;
        do {
            arpack.snaupd_c((int[])ido, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new IllegalStateException("ARPACK DNAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        float[] wr = new float[ncv * 2];
        float[] wi = new float[ncv * 2];
        int[] select = new int[ncv];
        float sigmar = 0.0f;
        float sigmai = 0.0f;
        boolean rvec = true;
        arpack.sneupd_c((boolean)rvec, (byte[])howmny, (int[])select, (float[])wr, (float[])wi, (float[])V, (int)ldv, (float)sigmar, (float)sigmai, (float[])workev, (byte[])bmat, (int)n, (byte[])bwhich, (int)nev, (float)tol, (float[])resid, (int)ncv, (float[])V, (int)ldv, (int[])iparam, (int[])ipntr, (float[])workd, (float[])workl, (int)workl.length, (int[])info);
        if (info[0] != 0) {
            String error = "ARPACK DNEUPD error code: " + info[0];
            if (info[0] == 1) {
                error = "ARPACK DNEUPD error: Maximum number of iterations reached.";
            } else if (info[0] == 3) {
                error = "ARPACK DNEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
            }
            throw new IllegalStateException(error);
        }
        nev = iparam[4];
        logger.info("ARPACK computed " + nev + " eigenvalues");
        wr = Arrays.copyOfRange(wr, 0, nev);
        wi = Arrays.copyOfRange(wi, 0, nev);
        V = Arrays.copyOfRange(V, 0, n * nev);
        FloatMatrix.EVD eig = new FloatMatrix.EVD(wr, wi, null, FloatMatrix.of(Layout.COL_MAJOR, n, nev, ldv, FloatBuffer.wrap(V)));
        return eig.sort();
    }

    public static Matrix.SVD svd(DMatrix A, int k) {
        return ARPACK.svd(A, k, Math.min(3 * k, Math.min(A.nrows(), A.ncols())), 1.0E-6);
    }

    public static Matrix.SVD svd(DMatrix A, int k, int ncv, double tol) {
        int m = A.nrows();
        int n = A.ncols();
        DMatrix ata = A.square();
        Matrix.EVD eigen = ARPACK.syev(ata, SymmOption.LM, k, ncv, tol);
        double[] s = eigen.wr;
        for (int i = 0; i < s.length; ++i) {
            s[i] = Math.sqrt(s[i]);
        }
        if (m >= n) {
            Matrix V = eigen.Vr;
            double[] Av = new double[m];
            double[] v = new double[n];
            Matrix U = new Matrix(m, s.length);
            for (int j = 0; j < s.length; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    v[i] = V.get(i, j);
                }
                A.mv(v, Av);
                for (i = 0; i < m; ++i) {
                    U.set(i, j, Av[i] / s[j]);
                }
            }
            return new Matrix.SVD(s, U, V);
        }
        Matrix U = eigen.Vr;
        double[] Atu = new double[n];
        double[] u = new double[m];
        Matrix V = new Matrix(n, s.length);
        for (int j = 0; j < s.length; ++j) {
            int i;
            for (i = 0; i < m; ++i) {
                u[i] = U.get(i, j);
            }
            A.tv(u, Atu);
            for (i = 0; i < n; ++i) {
                V.set(i, j, Atu[i] / s[j]);
            }
        }
        return new Matrix.SVD(s, U, V);
    }

    public static FloatMatrix.SVD svd(SMatrix A, int k) {
        return ARPACK.svd(A, k, Math.min(3 * k, Math.min(A.nrows(), A.ncols())), 1.0E-6f);
    }

    public static FloatMatrix.SVD svd(SMatrix A, int k, int ncv, float tol) {
        int m = A.nrows();
        int n = A.ncols();
        SMatrix ata = A.square();
        FloatMatrix.EVD eigen = ARPACK.syev(ata, SymmOption.LM, k, ncv, tol);
        float[] s = eigen.wr;
        for (int i = 0; i < s.length; ++i) {
            s[i] = (float)Math.sqrt(s[i]);
        }
        if (m >= n) {
            FloatMatrix V = eigen.Vr;
            float[] Av = new float[m];
            float[] v = new float[n];
            FloatMatrix U = new FloatMatrix(m, s.length);
            for (int j = 0; j < s.length; ++j) {
                int i;
                for (i = 0; i < n; ++i) {
                    v[i] = V.get(i, j);
                }
                A.mv(v, Av);
                for (i = 0; i < m; ++i) {
                    U.set(i, j, Av[i] / s[j]);
                }
            }
            return new FloatMatrix.SVD(s, U, V);
        }
        FloatMatrix U = eigen.Vr;
        float[] Atu = new float[n];
        float[] u = new float[m];
        FloatMatrix V = new FloatMatrix(n, s.length);
        for (int j = 0; j < s.length; ++j) {
            int i;
            for (i = 0; i < m; ++i) {
                u[i] = U.get(i, j);
            }
            A.tv(u, Atu);
            for (i = 0; i < n; ++i) {
                V.set(i, j, Atu[i] / s[j]);
            }
        }
        return new FloatMatrix.SVD(s, U, V);
    }

    public static enum AsymmOption {
        LM,
        SM,
        LR,
        SR,
        LI,
        SI;

    }

    public static enum SymmOption {
        LA,
        SA,
        LM,
        SM,
        BE;

    }
}

