/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.MercerKernel;
import smile.math.kernel.Polynomial;

public class BinarySparsePolynomialKernel
extends Polynomial
implements MercerKernel<int[]> {
    public BinarySparsePolynomialKernel(int degree) {
        this(degree, 1.0, 0.0);
    }

    public BinarySparsePolynomialKernel(int degree, double scale, double offset) {
        this(degree, scale, offset, new double[]{0.01, 1.0E-5}, new double[]{100.0, 100000.0});
    }

    public BinarySparsePolynomialKernel(int degree, double scale, double offset, double[] lo, double[] hi) {
        super(degree, scale, offset, lo, hi);
    }

    @Override
    public double k(int[] x, int[] y) {
        return this.k(MathEx.dot(x, y));
    }

    @Override
    public double[] kg(int[] x, int[] y) {
        return this.kg(MathEx.dot(x, y));
    }

    public BinarySparsePolynomialKernel of(double[] params) {
        return new BinarySparsePolynomialKernel(this.degree, params[0], params[1], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.scale, this.offset};
    }

    @Override
    public double[] lo() {
        return this.lo;
    }

    @Override
    public double[] hi() {
        return this.hi;
    }
}

