/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.util.Arrays;

public class IQAgent {
    private final int nbuf;
    private final int nq;
    private int nt;
    private int nd;
    private final double[] pval;
    private final double[] dbuf;
    private double[] qile;
    private double q0;
    private double qm;

    public IQAgent() {
        this(1000);
    }

    public IQAgent(int nbuf) {
        int j;
        this.nbuf = nbuf;
        this.nq = 251;
        this.nt = 0;
        this.nd = 0;
        this.q0 = 1.0E99;
        this.qm = -1.0E99;
        this.pval = new double[this.nq];
        this.dbuf = new double[nbuf];
        this.qile = new double[this.nq];
        for (j = 85; j <= 165; ++j) {
            this.pval[j] = ((double)j - 75.0) / 100.0;
        }
        for (j = 84; j >= 0; --j) {
            this.pval[j] = 0.87191909 * this.pval[j + 1];
            this.pval[250 - j] = 1.0 - this.pval[j];
        }
    }

    public void add(double datum) {
        this.dbuf[this.nd++] = datum;
        if (datum < this.q0) {
            this.q0 = datum;
        }
        if (datum > this.qm) {
            this.qm = datum;
        }
        if (this.nd == this.nbuf) {
            this.update();
        }
    }

    private void update() {
        int jd = 0;
        int jq = 1;
        double told = 0.0;
        double tnew = 0.0;
        double[] newqile = new double[this.nq];
        Arrays.sort(this.dbuf, 0, this.nd);
        this.qile[0] = newqile[0] = this.q0;
        double qnew = newqile[0];
        double qold = newqile[0];
        double d = this.qm;
        newqile[this.nq - 1] = d;
        this.qile[this.nq - 1] = d;
        this.pval[0] = Math.min(0.5 / (double)(this.nt + this.nd), 0.5 * this.pval[1]);
        this.pval[this.nq - 1] = Math.max(1.0 - 0.5 / (double)(this.nt + this.nd), 0.5 * (1.0 + this.pval[this.nq - 2]));
        for (int iq = 1; iq < this.nq - 1; ++iq) {
            double target = (double)(this.nt + this.nd) * this.pval[iq];
            if (tnew < target) {
                while (true) {
                    if (jq < this.nq && (jd >= this.nd || this.qile[jq] < this.dbuf[jd])) {
                        qnew = this.qile[jq];
                        int n = jq++;
                        tnew = (double)jd + (double)this.nt * this.pval[n];
                        if (tnew >= target) {
                            break;
                        }
                    } else {
                        qnew = this.dbuf[jd];
                        tnew = told;
                        if (this.qile[jq] > this.qile[jq - 1]) {
                            tnew += (double)this.nt * (this.pval[jq] - this.pval[jq - 1]) * (qnew - qold) / (this.qile[jq] - this.qile[jq - 1]);
                        }
                        ++jd;
                        if (tnew >= target) break;
                        double d2 = tnew;
                        tnew = d2 + 1.0;
                        told = d2;
                        qold = qnew;
                        if (tnew >= target) break;
                    }
                    told = tnew;
                    qold = qnew;
                }
            }
            newqile[iq] = tnew == told ? 0.5 * (qold + qnew) : qold + (qnew - qold) * (target - told) / (tnew - told);
            told = tnew;
            qold = qnew;
        }
        this.qile = newqile;
        this.nt += this.nd;
        this.nd = 0;
    }

    public double quantile(double p) {
        int j;
        if (this.nd > 0) {
            this.update();
        }
        int jl = 0;
        int jh = this.nq - 1;
        while (jh - jl > 1) {
            j = jh + jl >> 1;
            if (p > this.pval[j]) {
                jl = j;
                continue;
            }
            jh = j;
        }
        j = jl;
        double q = this.qile[j] + (this.qile[j + 1] - this.qile[j]) * (p - this.pval[j]) / (this.pval[j + 1] - this.pval[j]);
        return Math.max(this.qile[0], Math.min(this.qile[this.nq - 1], q));
    }
}

