/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.lang.reflect.Array;
import smile.sort.Sort;

public class HeapSelect<T extends Comparable<? super T>> {
    private final int k;
    private final T[] heap;
    private int n;
    private boolean sorted;

    public HeapSelect(Class<?> clazz, int k) {
        this((Comparable[])Array.newInstance(clazz, k));
    }

    public HeapSelect(T[] heap) {
        this.heap = heap;
        this.k = heap.length;
        this.n = 0;
        this.sorted = false;
    }

    public int size() {
        return this.n;
    }

    public T[] toArray() {
        return this.heap;
    }

    public T[] toArray(T[] a) {
        System.arraycopy(this.heap, 0, a, 0, this.k);
        return a;
    }

    public void add(T datum) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[this.n++] = datum;
            if (this.n == this.k) {
                HeapSelect.heapify(this.heap);
            }
        } else {
            ++this.n;
            if (datum.compareTo(this.heap[0]) < 0) {
                this.heap[0] = datum;
                Sort.siftDown(this.heap, (int)0, (int)(this.k - 1));
            }
        }
    }

    public void heapify() {
        if (this.n < this.k) {
            throw new IllegalStateException();
        }
        Sort.siftDown(this.heap, (int)0, (int)(this.k - 1));
    }

    public T peek() {
        return this.heap[0];
    }

    public T get(int i) {
        if (i > Math.min(this.k, this.n) - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (i == this.k - 1) {
            return this.heap[0];
        }
        if (!this.sorted) {
            HeapSelect.sort(this.heap, (int)Math.min(this.k, this.n));
            this.sorted = true;
        }
        return this.heap[this.k - 1 - i];
    }

    public void sort() {
        if (!this.sorted) {
            HeapSelect.sort(this.heap, (int)Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static <T extends Comparable<? super T>> void heapify(T[] arr) {
        int n = arr.length;
        for (int i = n / 2 - 1; i >= 0; --i) {
            Sort.siftDown(arr, (int)i, (int)(n - 1));
        }
    }

    private static <T extends Comparable<? super T>> void sort(T[] a, int n) {
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i = inc /= 3; i < n; ++i) {
                T v = a[i];
                int j = i;
                while (a[j - inc].compareTo(v) < 0) {
                    a[j] = a[j - inc];
                    if ((j -= inc) >= inc) continue;
                }
                a[j] = v;
            }
        } while (inc > 1);
    }
}

