/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.math.distance.Distance;
import smile.neighbor.KNNSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.NeighborBuilder;
import smile.neighbor.RNNSearch;
import smile.sort.HeapSelect;

public class LinearSearch<K, V>
implements KNNSearch<K, V>,
RNNSearch<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final List<K> keys;
    private final List<V> data;
    private final Distance<K> distance;

    public LinearSearch(K[] keys, V[] data, Distance<K> distance) {
        this(Arrays.asList(keys), Arrays.asList(data), distance);
    }

    public LinearSearch(List<K> keys, List<V> data, Distance<K> distance) {
        if (keys.size() != data.size()) {
            throw new IllegalArgumentException("Different size of keys and data objects");
        }
        this.keys = keys;
        this.data = data;
        this.distance = distance;
    }

    public LinearSearch(V[] data, Distance<K> distance, Function<V, K> key) {
        this(Arrays.asList(data), distance, key);
    }

    public LinearSearch(List<V> data, Distance<K> distance, Function<V, K> key) {
        this.data = data;
        this.keys = data.stream().map(key).collect(Collectors.toList());
        this.distance = distance;
    }

    public static <T> LinearSearch<T, T> of(T[] data, Distance<T> distance) {
        return new LinearSearch<T, T>(data, data, distance);
    }

    public static <T> LinearSearch<T, T> of(List<T> data, Distance<T> distance) {
        return new LinearSearch<T, T>(data, data, distance);
    }

    public String toString() {
        return String.format("Linear Search (%s)", this.distance);
    }

    private Neighbor<K, V> neighbor(int i, double distance) {
        return new Neighbor<K, V>(this.keys.get(i), this.data.get(i), i, distance);
    }

    @Override
    public Neighbor<K, V> nearest(K q) {
        double[] dist = ((Stream)this.keys.stream().parallel()).mapToDouble(x -> this.distance.d(x, q)).toArray();
        int index = -1;
        double nearest = Double.MAX_VALUE;
        for (int i = 0; i < dist.length; ++i) {
            if (!(dist[i] < nearest) || q == this.keys.get(i)) continue;
            index = i;
            nearest = dist[i];
        }
        return this.neighbor(index, nearest);
    }

    @Override
    public Neighbor<K, V>[] search(K q, int k) {
        int i;
        if (k <= 0) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (k > this.data.size()) {
            throw new IllegalArgumentException("Neighbor array length is larger than the data size");
        }
        double[] dist = ((Stream)this.keys.stream().parallel()).mapToDouble(x -> this.distance.d(x, q)).toArray();
        HeapSelect heap = new HeapSelect(NeighborBuilder.class, k);
        for (i = 0; i < k; ++i) {
            heap.add(new NeighborBuilder());
        }
        for (i = 0; i < dist.length; ++i) {
            NeighborBuilder datum = (NeighborBuilder)heap.peek();
            if (!(dist[i] < datum.distance) || q == this.keys.get(i)) continue;
            datum.distance = dist[i];
            datum.index = i;
            datum.key = this.keys.get(i);
            datum.value = this.data.get(i);
            heap.heapify();
        }
        heap.sort();
        return (Neighbor[])Arrays.stream((NeighborBuilder[])heap.toArray()).map(NeighborBuilder::toNeighbor).toArray(Neighbor[]::new);
    }

    @Override
    public void search(K q, double radius, List<Neighbor<K, V>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        double[] dist = ((Stream)this.keys.stream().parallel()).mapToDouble(x -> this.distance.d(x, q)).toArray();
        for (int i = 0; i < dist.length; ++i) {
            if (!(dist[i] <= radius) || q == this.keys.get(i)) continue;
            neighbors.add(this.neighbor(i, dist[i]));
        }
    }
}

