/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import smile.math.kernel.MercerKernel;

public class ProductKernel<T>
implements MercerKernel<T> {
    private final MercerKernel<T> k1;
    private final MercerKernel<T> k2;

    public ProductKernel(MercerKernel<T> k1, MercerKernel<T> k2) {
        this.k1 = k1;
        this.k2 = k2;
    }

    @Override
    public double k(T x, T y) {
        return this.k1.k(x, y) * this.k2.k(x, y);
    }

    @Override
    public double[] kg(T x, T y) {
        double[] kg1 = this.k1.kg(x, y);
        double[] kg2 = this.k2.kg(x, y);
        double[] kg = new double[kg1.length + kg2.length - 1];
        double k1 = kg1[0];
        double k2 = kg2[0];
        kg[0] = k1 + k2;
        int n1 = kg1.length;
        for (int i = 1; i < n1; ++i) {
            kg[i] = kg1[i] * k2;
        }
        int n2 = kg2.length;
        for (int i = 1; i < n2; ++i) {
            kg[n1 + i - 1] = kg2[i] * k1;
        }
        return kg;
    }

    @Override
    public MercerKernel<T> of(double[] params) {
        int n1 = this.k1.lo().length;
        return new ProductKernel<T>(this.k1.of(params), this.k2.of(Arrays.copyOfRange(params, n1, params.length)));
    }

    @Override
    public double[] hyperparameters() {
        return DoubleStream.concat(Arrays.stream(this.k1.hyperparameters()), Arrays.stream(this.k2.hyperparameters())).toArray();
    }

    @Override
    public double[] lo() {
        return DoubleStream.concat(Arrays.stream(this.k1.lo()), Arrays.stream(this.k2.lo())).toArray();
    }

    @Override
    public double[] hi() {
        return DoubleStream.concat(Arrays.stream(this.k1.hi()), Arrays.stream(this.k2.hi())).toArray();
    }
}

