/*
 * Decompiled with CFR 0.152.
 */
package smile.hash;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PerfectHash
implements Serializable {
    private final String[] keywords;
    private int[] table;
    private int[] kvals;
    private char min;
    private int[] select;

    public PerfectHash(String ... keywords) {
        this((int[])null, keywords);
    }

    public PerfectHash(int[] select, String ... keywords) {
        if (keywords.length == 0) {
            throw new IllegalArgumentException("Empty string set");
        }
        if (select != null) {
            this.select = Arrays.copyOf(select, select.length);
            Arrays.sort(this.select);
        }
        this.keywords = keywords;
        this.generate(keywords);
    }

    public int get(String key) {
        int i = this.hash(key);
        if (i < 0 || i >= this.table.length) {
            return -1;
        }
        int idx = this.table[i];
        if (!key.equals(this.keywords[idx])) {
            return -1;
        }
        return idx;
    }

    private int hash(String key) {
        int klen;
        int out = klen = key.length();
        if (this.select == null) {
            for (int i = 0; i < klen; ++i) {
                int c = key.charAt(i) - this.min;
                if (c < 0) {
                    return -1;
                }
                if (c >= this.kvals.length) {
                    return -2;
                }
                out += this.kvals[c];
            }
        } else {
            for (int i : this.select) {
                if (i >= klen) continue;
                int c = key.charAt(i) - this.min;
                if (c < 0) {
                    return -1;
                }
                if (c >= this.kvals.length) {
                    return -2;
                }
                out += this.kvals[c];
            }
        }
        return out;
    }

    private void sort(char[] arr, int[] freq) {
        for (int i = 1; i < arr.length; ++i) {
            for (int j = i; j > 0 && freq[arr[j]] < freq[arr[j - 1]]; --j) {
                char tmp = arr[j];
                arr[j] = arr[j - 1];
                arr[j - 1] = tmp;
            }
        }
    }

    private void add(Map<String, Key> map, String k, int v) {
        char[] ksig;
        int klen = k.length();
        if (this.select == null) {
            ksig = k.toCharArray();
        } else {
            ksig = new char[this.select.length];
            int idx = 0;
            for (int i : this.select) {
                if (i >= klen) continue;
                ksig[idx++] = k.charAt(i);
            }
            if (idx < ksig.length) {
                ksig = Arrays.copyOf(ksig, idx);
            }
        }
        Key prev = map.put(k, new Key(ksig, klen, v));
        if (prev != null) {
            throw new IllegalArgumentException(String.format("Duplicate key %s at %d and %d", k, prev.value, v));
        }
    }

    private int[] countCharacterFrequency(Map<String, Key> map) {
        int[] freq = new int[65535];
        for (Key m : map.values()) {
            char[] cArray = m.ksig;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char c;
                char c2 = c = cArray[i];
                freq[c2] = freq[c2] + 1;
            }
        }
        return freq;
    }

    private Key[] sortKeys(Map<String, Key> map, int[] freq) {
        Object[] keys = new Key[map.size()];
        int idx = 0;
        for (Key key : map.values()) {
            keys[idx++] = key;
            for (char c : key.ksig) {
                key.kfreq += freq[c];
            }
            this.sort(key.ksig, freq);
        }
        Arrays.sort(keys);
        return keys;
    }

    private char diff(char[] a, char[] b) {
        block0: for (char _a : a) {
            for (char _b : b) {
                if (_a == _b) continue block0;
            }
            return _a;
        }
        throw new IllegalArgumentException(String.format("Failed to find disjoint union of keysigs: %s and %s", Arrays.toString(a), Arrays.toString(b)));
    }

    private int hash(Key m) {
        int out = m.klen;
        for (char c : m.ksig) {
            out += this.kvals[c - this.min];
        }
        return out;
    }

    private void resolve(Key x, Key y, int[] kvals, char min) {
        char c = this.diff(x.ksig, y.ksig);
        int n = c - min;
        kvals[n] = kvals[n] + 1;
    }

    private void generate(String[] keywords) {
        int i;
        HashMap<String, Key> map = new HashMap<String, Key>();
        for (int i2 = 0; i2 < keywords.length; ++i2) {
            this.add(map, keywords[i2], i2);
        }
        int[] freq = this.countCharacterFrequency(map);
        Key[] keys = this.sortKeys(map, freq);
        this.min = (char)65535;
        char max = '\u0000';
        for (i = 0; i < freq.length; i = (int)((char)(i + 1))) {
            if (freq[i] <= 0) continue;
            this.min = (char)i;
            break;
        }
        for (i = freq.length - 1; i >= 0; --i) {
            if (freq[i] <= 0) continue;
            max = (char)i;
            break;
        }
        if (max < this.min) {
            throw new IllegalStateException("Failed to generate perfect hash. Possibly all empty keys.");
        }
        this.kvals = new int[max - this.min + 1];
        int vsize = keys.length;
        int tsize = vsize + (vsize >> 1);
        Object[] used = new Key[tsize];
        while (true) {
            for (Key key : keys) {
                int hash = this.hash(key);
                if (hash >= used.length) {
                    tsize = hash + 1;
                    used = new Key[tsize];
                    continue;
                }
                if (used[hash] != null) {
                    this.resolve(key, used[hash], this.kvals, this.min);
                    Arrays.fill(used, null);
                    continue;
                }
                used[hash] = key;
            }
            break;
        }
        this.table = new int[tsize];
        Arrays.fill(this.table, -1);
        for (Map.Entry entry : map.entrySet()) {
            Key m = (Key)entry.getValue();
            int hash = this.hash(m);
            if (this.table[hash] != -1) {
                throw new IllegalStateException("Failed to generate perfect hash.");
            }
            this.table[hash] = m.value;
        }
    }

    private static class Key
    implements Comparable<Key> {
        char[] ksig;
        int klen;
        int kfreq;
        int value;

        public Key(char[] ksig, int klen, int value) {
            this.ksig = ksig;
            this.klen = klen;
            this.kfreq = 0;
            this.value = value;
        }

        @Override
        public int compareTo(Key b) {
            return Integer.compare(b.kfreq, this.kfreq);
        }
    }
}

